; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - HICODE.prg
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Map
; -------------------------------------------------------------------------------------------------------------- ;
; $0000 - $00ff:  Zero Page Values
; $0100 - $01ff:  Processor stack
; $0200 - $02ff:  Work Values and C64 system
; $0300 - $03ff:  Work Values and C64 system
; $0400 - $07ff:  Screen: Status
; $0800 - $1dff:  Code: Basic
; $1e00 - $4003:  Code: LOcode
; $3c00 - $3fff:  Screen: Save
; $3f00 - $5e03:  Data: Sprites load - will be copied over to $e000-$fdff
; $4000 - $47ff:  Data: Char sets
; $4800 - $4bff:  Screen: 1st
; $4c00 - $4fff:  Screen: 2nd - for scrolling tanks on the beach
; $5000 - $6577:  Data: Sprites game
; $6850 - $c002:  Code: HIcode
; $c003 - $cfff:  <unused>
; $e000 - $fdff:  Data: Sprites raw
; $fe00 - $feff:  <unused>
; $ff00 - $ffff:  Kernel vectors
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $6580
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes

C64CIA1                 include cia1.asm            ; Complex Interface Adapter (CIA) #1 Registers  $DC00-$DC0F
C64CIA2                 include cia2.asm            ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64SID                  include sid.asm             ; Sound Interface Device (SID) Registers        $D400-$D41C
C64VicII                include vic.asm             ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Kernel               include kernel.asm          ; Kernel Vectors
C64Colors               include color.asm           ; Colour RAM Address / Colours
C64Memory               include mem.asm             ; Memory Layout

Game                    include inc\BH_Game.asm     ; Game Variables
Externals               include inc\BH_Externals.asm; Subroutines and Tables
ZeroPage                include inc\BH_Zpg.asm      ; Zero Page Addresses

Equates                 include inc\BH_Equates.asm  ; External and Unresolved Addresses
; -------------------------------------------------------------------------------------------------------------- ;
A_6580                  dc.b $81 ; 
                        dc.b $f7 ; 
                        dc.b $80 ; 
                        dc.b $8d ; 
                        dc.b $85 ; 
                        dc.b $fb ; 
                        dc.b $80 ; 
                        dc.b $8d ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShowStartScreen       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowStartScreen         jsr BL_GameInit             ;  
                        
                        ldx #$00                    ; 
.CopyKernalToRam        lda XT_ff00,x               ; 
                        sta XT_ff00,x               ; 
                        dex                         ; 
                        bne .CopyKernalToRam        ; 
                        
                        jsr BL_C64IrqScollInit      ; 
                        
                        lda #B_Koff                 ; 
                        sta R6510                   ; 
                        
                        jsr BL_ScreenStatusInitColor; 
                        
                        lda #$07                    ; 
                        sta HI_962f                 ; 
                        
                        lda TabVicMemControlSetA    ; 
                        sta TabVicMemControl        ; 
                        
                        lda #$01                    ; screen A
                        sta TabTankActiveScreen     ; 
                        
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        ora #$08                    ; ....#... - 40 columns
                        jsr ScreenShowStartGfx      ; 
                        
                        ldx #<ScreenDataIntro       ; 
                        ldy #>ScreenDataIntro       ; 
                        jsr BL_ScreenGraphicInit    ; Init game screen data - Intro
                        
                        ldy #$07                    ; 
                        ldx #<TabTextStatusByBruce  ; 
                        lda #BLACK                  ; 
                        sta TabScrnStatusTextColor  ; 
                        jsr BL_ScreenStatusTextOutRow1 ; xr=input text offset  yr=output text offset
                        
                        ldy #$07                    ; 
                        ldx #<TabTextStatusCopyright; 
                        jsr BL_ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        lda #$05                    ; 
                        sta HI_9617                 ; 
                        
                        jsr BL_WaitTOD              ; 
                        jsr ResetTODsHour           ; 
                        
                        sta TO2HRS                  ; CIA2($DD0B) Time of Day Clock Hours
                        
                        lda #BIKon                  ; 
                        sta R6510                   ; 
                        
                        jsr BL_C64Reset             ; 
                        
ShowStartScreenX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenShowStartGfx    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenShowStartGfx      subroutine                  ; 
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        ldx #<ScreenDataBayShore    ; 
                        ldy #>ScreenDataBayShore    ; 
                        jsr BL_ScreenGraphicCharSet ; 
                        
ScreenShowStartGfxX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ResetTODsHour         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ResetTODsHour           subroutine                  ; 
                        lda #$00                    ; 
                        sta HI_962f                 ; 
                        
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
                        sta TO2HRS                  ; CIA2($DD0B) Time of Day Clock Hours
                        
ResetTODsHourX          rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_65ff                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_65ff                  subroutine                  ; 
                        lda #$ff                    ; flag: blank
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$18                    ; 
                        ldx #<TabTextStatusByBruce + $0e ; "r"
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6609                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6609                  subroutine                  ; 
                        sta HI_9617                 ; 
                        jsr BL_ScreenStatusShowScore; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6610                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6610                  subroutine                  ; 
                        lda T_960c                  ; 
                        and #$01                    ; 
                        beq B_661e                  ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_661e                  lda #$fe                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6627                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6627                  subroutine                  ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta T_960c                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_662e                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_662e                  subroutine                  ; 
                        sta HI_972f                 ; 
                        lda #$01                    ; 
                        bit HI_9609                 ; 
                        bne B_6641                  ; 
                        lda #$06                    ; 
                        clc                         ; 
                        adc HI_972f                 ; 
                        sta HI_972f                 ; 
B_6641                  lda #$b0                    ; 
                        cmp HI_972f                 ; 
                        bcs B_664b                  ; 
                        sta HI_972f                 ; 
B_664b                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_664c                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_664c                  subroutine                  ; 
                        ldx TabActualPlayerNumber   ; 
                        jsr LO_3893                 ; PlayerValuesRestore
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_6653                 sta HI_96d0,x               ; 
                        sta HI_9656                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_665a                  lda TabGameMode             ; 
                        bmi B_6665                  ; demo
                        
                        lda CIAPRB                  ; CIA1($DC01) Data Port Register B
                        jmp LO_380f                 ; 
                        
B_6665                  jmp LO_3816                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_6668                 lda TabGameMode             ; 
                        bmi B_6673                  ; demo
                        
                        lda CIAPRB                  ; CIA1($DC01) Data Port Register B
                        jmp LO_3821                 ; 
                        
B_6673                  jmp LO_3828                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6676                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6676                  subroutine                  ; 
                        jsr BL_ScreenStatusSave     ; 
                        jsr BL_ScreenStatusInitColor; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_667d                 jsr BL_WaitTOD              ; 
                        jsr BL_ScreenStatusRestore  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6684                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6684                  subroutine                  ; 
                        ldx TabSkillLevel           ; 
B_6687                  jsr LO_3787                 ; 
                        jsr LO_3781                 ; 
                        
                        dex                         ; 
                        bpl B_6687                  ; 
                        
                        jsr BL_ScreenStatusShowScore; 
                        jsr S_8975                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6697                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6697                  subroutine                  ; 
                        ldx #$80                    ; 
                        lda XT_037f,x               ; 
                        clc                         ; 
                        adc #$01                    ; 
                        cmp BH_Scrn_Status + $037f,x; 
                        beq B_66ab                  ; 
                        sta U_95ac,x                ; 
                        inx                         ; 
                        sta U_95ac,x                ; 
B_66ab                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_66ac                 jsr LO_2540                 ; 
                        jsr LO_254b                 ; 
                        jsr LO_2556                 ; 
                        lda #$ff                    ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        lda #$3a                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$07                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_66ca                 jsr LO_1fd4                 ; 
                        
                        jmp J_665a                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_66d0                  dc.b $00 ; .hbu.
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $10 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $90 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $71 ; 
A_66e0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7d ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $04 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $09 ; 
A_66f0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $2c ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $48 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
A_6700                  dc.b $05 ; 
                        dc.b $2d ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $01 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $77 ; 
                        dc.b $81 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $f7 ; 
A_6710                  dc.b $20 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7b ; 
A_6720                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $4d ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
A_6730                  dc.b $40 ; 
                        dc.b $7f ; 
                        dc.b $05 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_6740                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $8d ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $8d ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
A_6750                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $84 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $98 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
A_6760                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $84 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $75 ; 
A_6770                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $f7 ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $f7 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
A_6780                  dc.b $81 ; 
                        dc.b $f7 ; 
                        dc.b $80 ; 
                        dc.b $8d ; 
                        dc.b $85 ; 
                        dc.b $fb ; 
                        dc.b $80 ; 
                        dc.b $8d ; 
                        dc.b $01 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ad ; 
                        dc.b $85 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $5f ; 
A_6790                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
A_67a0                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $85 ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $84 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
A_67b0                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $f7 ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $44 ; 
A_67c0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $04 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
A_67d0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $18 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $90 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $f3 ; 
A_67e0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $04 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $09 ; 
A_67f0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $2d ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $48 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $04 ; 
                        dc.b $05 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShowBayAreaMap        Does    : Display the bay area map - Main Loop
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowBayAreaMap          nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda TabVicMemControlSetA    ; 
                        sta TabVicMemControl        ; 
                        
                        lda #$01                    ; screen A
                        sta TabTankActiveScreen     ; 
                        
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        ora #$08                    ; ....#... - 40 columns
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        jsr InitBayAreaMap          ; 
                        
                        lda #$03                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$01                    ; 
                        sta T_9611                  ; 
                        
.MainLoop               jsr MapMoveMyFleet          ; 
                        jsr MapChkMyFleetHitLand    ; 
                        jsr MapMyFleetEnterCave     ; cave crossing chapter
                        jsr MapCloseChaseMyFleet    ; 
                        jsr MapHitMyFleetShootOut   ; sea  shootout chapters
                        jsr MapHitBeachTankHill     ; tank shootout chapters
                        jsr BL_MapBlinkTargetsPing  ; 
                        jsr LO_37e2                 ; 
                        jsr BL_ScreenStatusShowScore; 
                        jsr BL_MapChkIdleTimeReturn ; 
                        jsr BL_ScreenStatusShowShips; 
                        jsr LO_39df                 ; 
                        jsr MapStartDemo            ; 
                        
ShowBayAreaMapX         jmp .MainLoop               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; InitBayAreaMap        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitBayAreaMap          subroutine                  ; 
                        jsr BL_ScreenReadyPrepareMap; go --> display 'get ready' screen
                        nop                         ;        xr=$00 yr=$9b
                        jsr BL_ScreenGraphicInit    ; Init game screen data - Map
                        jsr ScreenStatusMap         ; 
                        
                        nop                         ; 
                        nop                         ; 
                        jsr SpritesReset            ; 
                        
                        ldx #$01                    ; 
                        jsr BL_MapSetSpritesSound   ; 
                        
                        lda #$06                    ; 
                        sta HI_96d8                 ; 
                        sta HI_96e8                 ; 
                        
                        lda #$05                    ; 
                        sta T_96d9                  ; 
                        sta T_96e9                  ; 
                        
                        lda #$20                    ; 
                        sta T_96da                  ; 
                        
                        lda #$00                    ; 
                        sta HI_9670                 ; 
                        sta HI_9678                 ; 
                        
                        lda #$40                    ; --> $c0
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$01                    ; --> remove
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$32                    ; --> $48
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$43                    ; 
                        sta BH_SpritePointer00      ; 
                        
                        lda #$6e                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$b2                    ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        lda #$48                    ; 
                        sta BH_SpritePointer01      ; 
                        
                        lda #$01                    ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        
                        lda #$01                    ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        
                        lda #$00                    ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
InitBayAreaMapX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMoveMyFleet        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleet          subroutine                  ; 
                        jmp MapMoveMyFleetChkLeft   ; goes and ...
                        nop                         ; 
                        nop                         ; 
MapMoveMyFleetJoyLeft   beq .ChkRight               ; ... comes back here ...
                        
.WasLeft                jsr MapMoveMyFleetSetLeft   ; 
                        nop                         ; 
                        nop                         ; 
                        jmp .ChkUp                  ; 
                        
.ChkRight               lda #CIA_Joy_Ri             ; ....#...
                        bit TabJoysticAction        ; 
                        beq .ChkUp                  ; 
                        
.WasRight               jsr MapMoveMyFleetSetRight  ; 
                        nop                         ; 
                        nop                         ; 
.ChkUp                  lda #CIA_Joy_Up             ; .......#
                        bit TabJoysticAction        ; 
                        beq .ChkDown                ; 
                        
.WasUp                  jsr MapMoveMyFleetSetUp     ; 
                        nop                         ; 
                        nop                         ; 
                        jmp MapMoveMyFleetJoyReset  ; 
                        
.ChkDown                lda #CIA_Joy_Do             ; ......#.
                        bit TabJoysticAction        ; 
                        beq MapMoveMyFleetJoyReset  ; 
                        
.WasDown                jsr MapMoveMyFleetSetDown   ; 
                        nop                         ; 
                        nop                         ; 
                        
MapMoveMyFleetJoyReset  lda #$00                    ; ... or here
                        sta TabJoysticAction        ; 
                        
                        lda HI_96b0                 ; 
                        beq .MoveMyFleet            ; 
                        
                        rts                         ; 
                        
.MoveMyFleet            inc HI_96b0                 ; 
                        
                        lda HI_9670                 ; 
.ChkMoveLeft            cmp #TabMoveSpriteLe        ; 
                        bne .ChkMoveRight           ; 
                        
                        jsr MapMoveMyFleetLeft      ; 
                        jmp .ChkMoveDown            ; 
                        
.ChkMoveRight           cmp #TabMoveSpriteRi        ; 
                        bne .ChkMoveDown            ; 
                        
                        jsr MapMoveMyFleetRight     ; 
                        
.ChkMoveDown            lda HI_9678                 ; 
                        cmp #TabMoveSpriteDo        ; 
                        bne .ChkMoveUp              ; 
                        
                        jsr MapMoveMyFleetDown      ; 
                        jmp MapMoveMyFleetX         ; 
                        
.ChkMoveUp              cmp #TabMoveSpriteUp        ; 
                        bne MapMoveMyFleetX         ; 
                        
                        jsr GoMapMoveMyFleetUp      ; 
                        
MapMoveMyFleetX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
GoMapMoveMyFleetUp      jmp MapMoveMyFleetUp        ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_6927                  cpx #$e0                    ; .hbu. - <obsolete>
A_6929                  bcc MapMoveMyFleetUp        ; 
                        
A_692b                  lda HI_9609                 ; 
A_692e                  beq MapMoveMyFleetUp        ; 
                        
A_6930                  ldx SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
A_6933                  cpx #$92                    ; 
A_6935                  bcc MapMoveMyFleetUpX       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMoveMyFleetUp      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetUp        subroutine                  ; 
                        lda #$2e                    ; 
                        cmp SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq MapMoveMyFleetUpX       ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta HI_960b                 ; 
                        
                        dec SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
MapMoveMyFleetUpX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMoveMyFleetDown    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetDown      subroutine                  ; 
                        lda #$b9                    ; 
                        cmp SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq MapMoveMyFleetDownX     ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta HI_960b                 ; 
                        
                        inc SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
MapMoveMyFleetDownX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMoveMyFleetLeft    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetLeft      subroutine                  ; 
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_6977                  ; 
                        
                        lda #$14                    ; 
                        cmp SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq B_6976                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta T_960a                  ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta T_960c                  ; 
                        
                        dec SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
B_6976                  rts                         ; 
                        
B_6977                  lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta T_960a                  ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta T_960c                  ; 
                        
                        dec SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bpl B_6976                  ; 
                        
                        lda #$fe                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
MapMoveMyFleetLeftX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMoveMyFleetRight   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetRight     subroutine                  ; 
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_69b2                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta T_960a                  ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta T_960c                  ; 
                        
                        inc SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bne B_69b1                  ; 
                        
                        lda #$01                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
B_69b1                  rts                         ; 
                        
B_69b2                  lda #$44                    ; 
                        cmp SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq B_69b1                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta T_960a                  ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta T_960c                  ; 
                        
                        inc SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
MapMoveMyFleetRightX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapChkMyFleetHitLand  Does  : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapChkMyFleetHitLand    subroutine                  ; 
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        and #$01                    ; .......#
                        bne B_69d1                  ; 
                        
                        rts                         ; 
                        
B_69d1                  lda T_960a                  ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        jsr S_6610                  ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda HI_960b                 ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
MapChkMyFleetHitLandX   rts                        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetEnterCave   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetEnterCave     subroutine                  ; 
                        lda HI_9609                 ; 
                        beq B_69ea                  ; 
                        
B_69e9                  rts                         ; 
                        
B_69ea                  lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$01                    ; 
                        bne B_69e9                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$80                    ; 
                        bcc B_69e9                  ; 
                        
                        cmp #$88                    ; 
                        bcs B_69e9                  ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$4a                    ; 
                        bcc B_69e9                  ; 
                        
                        cmp #$5a                    ; 
                        bcs B_69e9                  ; 
                        
                        jmp LO_2521                 ; 
                        
HI_6a0a                 lda #$01                    ; 
                        sta HI_9609                 ; 
                        jsr InitBayAreaMap          ; 
                        
                        lda #$70                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$00                    ; 
                        jsr S_6627                  ; 
                        
                        lda #$78                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        jsr S_8d70                  ; 
                        jsr SpritesReset            ; 
                        
                        lda #$43                    ; 
                        sta BH_SpritePointer00      ; 
                        
                        lda #$03                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
MapMyFleetEnterCaveX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapCloseChaseMyFleet  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapCloseChaseMyFleet    subroutine                  ; 
                        lda T_9611                  ; 
                        bne B_6a38                  ; 
                        
B_6a37                  rts                         ; 
                        
B_6a38                  lda HI_9609                 ; 
                        bne B_6a4c                  ; 
                        
                        jmp J_8d1b                  ; 
                        
J_6a40                  cmp #$91                    ; 
                        bcc B_6a37                  ; 
                        
J_6a44                  lda #$80                    ; 
                        sta HI_9609                 ; 
J_6a49                  jmp J_8d33                  ; 
                        
B_6a4c                  cmp #$01                    ; 
                        bne B_6a69                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$a0                    ; 
                        bcc B_6a5f                  ; 
                        
J_6a57                  lda #$81                    ; 
                        sta HI_9609                 ; 
                        jmp J_6a49                  ; 
                        
B_6a5f                  lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$a2                    ; 
                        bne B_6a37                  ; 
                        
                        jmp J_6a57                  ; 
                        
B_6a69                  jsr S_6a6d                  ; 
                        
MapCloseChaseMyFleetX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6a6d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6a6d                  subroutine                  ; 
                        lda T_96b1                  ; 
                        beq B_6a73                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6a73                  lda #$01                    ; 
                        sta T_96b1                  ; 
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq B_6aa5                  ; 
                        bcs B_6a98                  ; 
                        jmp J_8d53                  ; 
J_6a85                  sec                         ; 
                        sbc #$01                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs B_6aa5                  ; 
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$fd                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp B_6aa5                  ; 
B_6a98                  inc SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bne B_6aa5                  ; 
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        ora #$02                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
B_6aa5                  lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        beq B_6ab6                  ; 
                        bcs B_6ab3                  ; 
                        dec SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6ab3                  inc SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
B_6ab6                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapHitMyFleetShootOut Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapHitMyFleetShootOut   subroutine                  ; 
                        lda T_9611                  ; 
                        bne B_6abd                  ; 
                        
B_6abc                  rts                         ; 
                        
B_6abd                  lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_6acc                  ; 
                        
B_6ac4                  lda SPSPCL                  ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                        and #$03                    ; ......##
                        bne B_6af5                  ; 
                        
                        rts                         ; 
                        
B_6acc                  lda #$02                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_6ac4                  ; 
                        
                        sec                         ; 
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sbc SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs B_6ae0                  ; 
                        
                        eor #$ff                    ; 
                        adc #$01                    ; 
B_6ae0                  cmp #$08                    ; 
                        bcs B_6abc                  ; 
                        
                        sec                         ; 
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sbc SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        bcs B_6af1                  ; 
                        
                        eor #$ff                    ; 
                        adc #$01                    ; 
B_6af1                  cmp #$08                    ; 
                        bcs B_6abc                  ; 
                        
B_6af5                  lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta T_960a                  ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta T_960c                  ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        jsr LO_2527                 ; 
                        
MapHitMyFleetShootOutX  jmp ChapPlaneShootout       ; Start Chapter 02 - Plane shootout
; -------------------------------------------------------------------------------------------------------------- ;
HI_6b0a                 lda #$00                    ; 
                        sta T_9611                  ; 
                        jsr InitBayAreaMap          ; 
                        
                        lda T_960a                  ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda T_960c                  ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda HI_960b                 ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        lda #$00                    ; 
                        jsr HI_8d82                 ; 
                        jmp J_6b2f                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta BH_SpritePointer00      ; 
                        
J_6b2f                  lda #$01                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapHitBeachTankHill   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapHitBeachTankHill     subroutine                  ; 
                        lda T_9611                  ; 
                        beq B_6b3b                  ; 
                        
B_6b3a                  rts                         ; 

B_6b3b                  lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$60                    ; 
                        bcc B_6b3a                  ; 
                        
                        cmp #$68                    ; 
                        bcs B_6b3a                  ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$b2                    ; 
                        bcc B_6b3a                  ; 
                        
                        cmp #$ba                    ; 
                        bcs B_6b3a                  ; 
                        
                        jsr LO_1f97                 ; 
                        nop                         ; 
                        jsr S_664c                  ; 
                        
MapHitBeachTankHillX    jmp LO_252e                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_6b5b                 lda T_96b2                  ; 
                        beq B_6b61                  ; 
                        
                        rts                         ; 
                        
B_6b61                  inc T_96b2                  ; 
                        
                        jsr S_8c81                  ; 
                        bne B_6b6f                  ; 
                        
                        lda #$07                    ; 
                        sta BGCOL1                  ; VIC($D022) Background Color 1
                        
                        rts                         ; 
                        
B_6b6f                  lda #$00                    ; 
                        sta BGCOL1                  ; VIC($D022) Background Color 1
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapStartDemo          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapStartDemo            subroutine                  ; 
                        lda TabGameMode             ; 
                        bne B_6b7b                  ; 
                        
                        rts                         ; 
                        
B_6b7b                  cmp #$01                    ; 
                        bne B_6ba2                  ; 
                        
                        lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$05                    ; 
                        beq B_6b8c                  ; 
                        
                        lda #[CIA_Joy_Do + CIA_Joy_Le] ; .....##.
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
                        
B_6b8c                  jsr BL_InitTOD              ; 
                        
                        lda #$fe                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$83                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$4a                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        rts                         ; 
                        
B_6ba2                  cmp #$02                    ; 
                        bne B_6bc8                  ; 
                        
                        lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$20                    ; 
                        beq B_6bb8                  ; 
                        
                        lda #$a2                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$a0                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        rts                         ; 
                        
B_6bb8                  jsr BL_InitTOD              ; 
                        
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        rts                         ; 
                        
B_6bc8                  lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$03                    ; 
                        beq B_6bd5                  ; 
                        
                        lda #[CIA_Joy_Do + CIA_Joy_Le] ; .....##.
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
                        
B_6bd5                  jsr BL_InitTOD              ; 
                        
                        lda #$62                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$b4                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
MapStartDemoX           rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusMap       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusMap         subroutine                  ; 
HI_6be3                 equ *                       ; 
                        jsr BL_ScreenStatusInitColor; 
                        jsr BL_ScreenStatusInitGfx  ; 
                        jsr BL_ScreenStatusInitShips; 
                        
                        lda #YELLOW                 ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$19                    ; 
                        ldx #<TabTextStatus40mm     ; 
                        jsr BL_ScreenStatusTextOutRow2 ; xr=input text offset  yr=output text offset
                        
                        lda #CYAN                   ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$18                    ; 
                        ldx #<TabTextStatus250mm    ; 
                        jsr BL_ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        lda #LT_GREEN               ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$1d                    ; 
                        ldx #<TabTextStatusAmmoCube ; 
                        jsr BL_ScreenStatusTextOutRow2 ; xr=input text offset  yr=output text offset
                        
                        lda #BROWN                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$1d                    ; 
                        ldx #<TabTextStatusAmmoCube ; 
                        jsr BL_ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        lda #WHITE                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$16                    ; 
                        ldx #<TabTextStatusArialRec ; 
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
ScreenStatusMapX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ChapCaveCrossings     Does    : Chapter: Mine and torpedo cave
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ChapCaveCrossings       jsr BL_ScreenStatusSave     ; 
                        jsr BL_ScreenStatusGetReady ; 
                        jsr BL_ScreenStatusRestore  ; 
                        
                        ldx #<ScreenDataCave        ; 
                        ldy #>ScreenDataCave        ; 
                        jsr BL_ScreenGraphicInit    ; Init game screen data - Cave
                        jsr S_7039                  ; 
                        
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        ldx #$02                    ; 
                        jsr BL_SpriteDataCopyInit   ; 
                        jsr S_6c79                  ; 
                        jsr LO_25c6                 ; 
                        
.CaveLoop               jsr CaveMoveShip            ; 
                        jsr BL_SimpleCheckBasicMods ; <obsolete>
                        jsr SimpleRTS               ; <obsolete>
                        jsr BL_GetSprtSprtCollReg   ; sprite/sprite collision
                        jsr S_6efa                  ; 
                        jsr S_6f62                  ; 
                        jsr S_6f98                  ; 
                        jsr BL_ScreenStatusShowShips; 
                        jsr LO_2243                 ; 
                        jsr LO_37e2                 ; 
                        jsr BL_ScreenStatusShowScore; 
                        jsr LO_381e                 ; 
                        jsr LO_39df                 ; 
                        jsr S_6ff4                  ; 
                        
ChapCaveCrossingsX      jmp .CaveLoop               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6c79                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6c79                  subroutine                  ; 
                        lda #$43                    ; 
                        sta BH_SpritePointer01      ; 
                        lda #$43                    ; 
                        sta BH_SpritePointer02      ; 
                        lda #$43                    ; 
                        sta BH_SpritePointer03      ; 
                        lda #$44                    ; 
                        sta BH_SpritePointer04      ; 
                        lda #$44                    ; 
                        sta BH_SpritePointer05      ; 
                        lda #$44                    ; 
                        sta BH_SpritePointer06      ; 
                        lda #$44                    ; 
                        sta BH_SpritePointer07      ; 
                        
                        lda #$08                    ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        sta SP6COL                  ; VIC($D02D) Color Sprite 6
                        
                        lda #$0d                    ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        
                        lda #$04                    ; 
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        
                        lda #$00                    ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$fe                    ; 
                        sta SPBGPR                  ; VIC($D01B) Sprite to Foreground Display Priority
                        
                        nop                         ; 
                        nop                         ; 
                        
HI_6cca                 equ * + $01                 ;                         
                        lda #$9e                    ; 
                        sta T_9701                  ; 
                        
HI_6ccf                 equ * + $01                 ;                         
                        lda #$8f                    ; 
                        sta T_9709                  ; 
                        
HI_6cd4                 equ * + $01                 ;                         
                        lda #$18                    ; 
                        sta T_9702                  ; 
                        
HI_6cd9                 equ * + $01                 ;                         
                        lda #$0c                    ; 
                        sta T_970a                  ; 
                        
HI_6cde                 equ * + $01                 ;                         
                        lda #$98                    ; 
                        sta T_9703                  ; 
                        
HI_6ce3                 equ * + $01                 ;                         
                        lda #$8c                    ; 
                        sta T_970b                  ; 
                        
HI_6ce8                 equ * + $01                 ;                         
                        lda #$1e                    ; 
                        sta HI_9704                 ; 
                        
HI_6ced                 equ * + $01                 ;                         
                        lda #$14                    ; 
                        sta HI_9705                  ; 
                        
HI_6cf2                 equ * + $01                 ;                         
                        lda #$a0                    ; 
                        sta T_9706                  ; 
                        
HI_6cf7                 equ * + $01                 ;                         
                        lda #$1e                    ; 
                        sta T_9707                  ; 
                        lda #$00                    ; 
                        sta HI_970c                 ; 
                        sta T_970d                  ; 
                        sta T_970e                  ; 
                        sta T_970f                  ; 
                        lda #$05                    ; 
                        sta HI_9618                 ; 
                        
                        ldx #$07                    ; 
B_6d10                  jsr HI_6d3e                 ; 
                        jsr SimpleRTS               ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$01                    ; 
                        sta HI_9798,x               ; 
                        
                        dex                         ; 
                        bne B_6d10                  ; 
                        
                        lda #$fe                    ; #######.
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
B_6d2f                  lda #$ef                    ; 
                        jmp J_6d4e                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HI_6d3e               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HI_6d3e                 subroutine                  ; 
                        cpx #$01                    ; 
                        bne B_6d55                  ; 
                        lda #$df                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$27                    ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        lda #$fd                    ; 
J_6d4e                  and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6d55                  cpx #$02                    ; 
                        bne B_6d68                  ; 
                        lda #$26                    ; 
                        sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$b7                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        lda #$fb                    ; 
                        jmp J_6d4e                  ; 
B_6d68                  cpx #$03                    ; 
                        bne B_6d7b                  ; 
                        lda #$3f                    ; 
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$5f                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        lda #$08                    ; 
                        jmp J_6d8b                  ; 
B_6d7b                  cpx #$04                    ; 
                        bne B_6d92                  ; 
                        lda #$0c                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        jsr S_8c9c                  ; 
                        nop                         ; 
                        nop                         ; 
                        bne B_6d2f                  ; 
J_6d8b                  ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6d92                  cpx #$05                    ; 
                        bne B_6da5                  ; 
                        lda #$0c                    ; 
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$7f                    ; 
                        sta SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        lda #$df                    ; 
                        jmp J_6d4e                  ; 
B_6da5                  cpx #$06                    ; 
                        bne B_6db8                  ; 
                        lda #$5f                    ; 
                        sta SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$5f                    ; 
                        sta SP6Y                    ; VIC($D00D) Sprite 6 Y-Pos (Bits 0-7)
                        lda #$40                    ; 
                        jmp J_6d8b                  ; 
B_6db8                  lda #$0c                    ; 
                        sta SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$43                    ; 
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        lda #$7f                    ; 
                        jmp J_6d4e                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HI_6dc7               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HI_6dc7                 subroutine                  ; 
                        lda #$49                    ; 
                        jsr LO_25e0                 ; 
                        lda #$01                    ; 
                        sta HI_975e                 ; 
                        lda #$10                    ; 
                        sta HI_96f8                 ; 
                        sta HI_96a8                 ; 
                        lda #$08                    ; 
                        sta T_96f9                  ; 
                        sta T_96a9                  ; 
                        lda #$00                    ; 
                        sta HI_9613                 ; 
                        lda #$01                    ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        lda #$20                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$01                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #$a2                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$01                    ; 
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$00                    ; 
                        jsr S_8c90                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveMoveShip          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveMoveShip            subroutine                  ; 
                        lda HI_96d0                 ; 
                        bne .GoClearLeRi            ; 
                        
                        inc HI_96d0                 ; 
                        
.ChkRight               lda #CIA_Joy_Le             ; .....#..
                        bit TabJoysticAction        ; 
                        beq .ChkLeft                ; 
                        
                        jsr BL_ClearDirInJoyAction  ; 
                        
                        lda HI_975e                 ; 
                        beq .GoClearLeRi            ; 
                        
                        dec HI_975e                 ; 
                        
                        jmp .GoClearLeRi            ; 
                        
.ChkLeft                lda #CIA_Joy_Ri             ; ....#...
                        bit TabJoysticAction        ; 
                        beq .GoClearLeRi            ; 
                        
                        jsr BL_ClearDirInJoyAction  ; 
                        
                        lda HI_975e                 ; 
                        cmp #$04                    ; 
                        beq .GoClearLeRi            ; 
                        
                        inc HI_975e                 ; 
                        
.GoClearLeRi            jsr ClearJoyActionLeRi      ; 
                        
                        clc                         ; 
                        adc #$48                    ; 
                        sta BH_SpritePointer00      ; 
                        
                        lda T_96d1                  ; 
                        bne B_6e76                  ; 
                        
                        inc T_96d1                  ; 
                        
.ChkUp                  lda #CIA_Joy_Up             ; .......#
                        bit TabJoysticAction        ; 
                        beq .ChkDown                ; 
                        
                        jsr BL_ClearDirInJoyAction  ; 
                        lda HI_9613                 ; 
                        cmp #$07                    ; 
                        beq B_6e76                  ; 
                        
                        inc HI_9613                 ; 
                        jmp B_6e76                  ; 
                        
.ChkDown                lda #CIA_Joy_Do             ; ......#.
                        bit TabJoysticAction        ; 
                        beq B_6e76                  ; 
                        
                        jsr BL_ClearDirInJoyAction  ; 
                        
                        lda HI_9613                 ; 
                        beq B_6e76                  ; 
                        
                        dec HI_9613                 ; 
                        
B_6e76                  lda #$04                    ; 
                        sec                         ; 
                        sbc HI_975e                 ; 
                        jsr S_6eb0                  ; 
                        
                        ora #$80                    ; 
                        sta HI_9700                 ; 
                        
                        lda HI_975e                 ; 
                        jsr S_6eb0                  ; 
                        
                        sta HI_9708                 ; 
                        
                        lda #$01                    ; 
                        sta HI_9798                 ; 
                        
CaveMoveShipX           rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        asl BH_Scrn_Status + $01d0,x; 
                        lda #$00                    ; 
                        sta HI_9658                 ; 
                        lda HI_975e                 ; 
                        jsr S_6eb0                  ; 
                        sta HI_9708                 ; 
                        cmp #$1e                    ; 
                        bne B_6ead                  ; 
                        lda #$00                    ; 
                        sta HI_9660                 ; 
B_6ead                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_6eae                  dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6eb0                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6eb0                  subroutine                  ; 
                        sta HI_9740                 ; 
                        
                        ldx HI_9613                 ; 
                        bne B_6ebb                  ; 
                        
                        lda #$00                    ; 
                        
                        rts                         ; 
                        
B_6ebb                  dex                         ; 
                        beq B_6ec8                  ; 
                        
                        clc                         ; 
B_6ebf                  adc HI_9740                 ; 
                        
                        dex                         ; 
                        bne B_6ebf                  ; 
                        
                        sta HI_9740                 ; 
                        
B_6ec8                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_6ec9                  dc.b $1e ; .hbu.
                        dc.b $38 ; 
                        dc.b $ed ; 
                        dc.b $40 ; 
                        dc.b $97 ; 
                        dc.b $60 ; 
                        dc.b $00 ; 
A_6ed0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_6ee0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_6ef0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6efa                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6efa                  subroutine                  ; 
                        lda T_9614                  ; 
                        beq B_6f00                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6f00                  jsr S_8ce5                  ; 
                        and #$01                    ; 
                        bne B_6f08                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6f08                  jsr S_8cca                  ; 
                        lda #WHITE                  ; 
                        sta TabBackGroundColor      ; 
                        
B_6f10                  jsr S_8cb6                  ; 
                        beq B_6f10                  ; 
                        
                        lda #BLACK                  ; 
                        sta TabBackGroundColor      ; 
                        
                        lda #$4d                    ; 
                        sta BH_SpritePointer00      ; 
                        
                        lda #$08                    ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        lda #$02                    ; 
                        sta HI_9618                 ; 
                        jsr LO_3408                 ; 
                        lda #$4e                    ; 
                        sta BH_SpritePointer00      ; 
                        
                        jsr LO_3408                 ; 
                        lda #$4f                    ; 
                        sta BH_SpritePointer00      ; 
                        
                        lda #$02                    ; 
                        sta HI_9618                 ; 
                        jsr LO_3408                 ; 
                        nop                         ; 
                        nop                         ; 
                        jsr S_8cbc                  ; 
                        dec TabPlayerLives          ; 
                        bne B_6f58                  ; 
                        jsr LO_39b6                 ; 
                        lda #$00                    ; 
                        jmp LO_2c15                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_6f53                 pla                         ; 
                        pla                         ; 
                        pla                         ; 
                        pla                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6f58                  jmp J_8cf8                  ; 
J_6f5b                  jsr S_8cb0                  ; 
                        jsr HI_6dc7                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6f62                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6f62                  subroutine                  ; 
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$38                    ; 
                        bcc B_6f6a                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6f6a                  lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$3e                    ; 
                        bcc B_6f72                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6f72                  lda #$01                    ; 
                        sta T_9614                  ; 
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq B_6f82                  ; 
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq B_6f82                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6f82                  jsr LO_2400                 ; 
                        ldx HI_9612                 ; 
                        inx                         ; 
                        jsr S_8ca9                  ; 
                        bne B_6f91                  ; 
J_6f8e                  jmp LO_2bfe                 ; 
B_6f91                  jsr HI_6dc7                 ; 
                        jsr S_8cb0                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6f98                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6f98                  subroutine                  ; 
                        ldx #$07                    ; 
B_6f9a                  lda HI_9708,x               ; 
                        nop                         ; 
                        nop                         ; 
                        bmi B_6fac                  ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq B_6fee                  ; 
                        jmp J_6fba                  ; 
B_6fac                  nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$b8                    ; 
                        bcs B_6fee                  ; 
J_6fba                  lda HI_9700,x               ; 
                        nop                         ; 
                        nop                         ; 
                        bpl B_6fd4                  ; 
                        jsr LO_350f                 ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_6fea                  ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq B_6fee                  ; 
                        jmp B_6fea                  ; 
B_6fd4                  nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jsr LO_350f                 ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_6fea                  ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$50                    ; 
                        bcs B_6fee                  ; 
B_6fea                  dex                         ; 
                        bne B_6f9a                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_6fee                  jsr LO_25d0                 ; 
                        jmp B_6fea                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_6ff4                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_6ff4                  subroutine                  ; 
                        lda TabGameMode             ; 
                        bne B_6ffa                  ; 
                        
                        rts                         ; 
                        
B_6ffa                  lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$20                    ; 
                        bne B_700c                  ; 
                        
                        jsr BL_InitTOD              ; 
                        
                        lda #$02                    ; 
                        sta TabGameMode             ; 
                        
                        pla                         ; 
                        pla                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_700c                  cmp #$06                    ; 
                        bne B_7016                  ; 
                        
                        lda #CIA_Joy_Up             ; 
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7016                  cmp #$09                    ; 
                        bne B_7020                  ; 
                        
                        lda #CIA_Joy_Ri             ; 
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
                        
B_7020                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_7021                  dc.b $01 ; 
                        sta TabJoysticAction        ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7026                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7026                  subroutine                  ; 
                        lda TabGameMode             ; 
                        bne B_702c                  ; 
                        
                        rts                         ; 
                        
B_702c                  lda #$02                    ; 
                        sta TabGameMode             ; 
                        jsr BL_InitTOD              ; 
                        
                        pla                         ; 
                        pla                         ; 
                        jmp J_6f8e                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7039                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7039                  subroutine                  ; 
                        lda #$ff                    ; flag: blank
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$16                    ; 
                        ldx #<TabTextStatusByBruce + $0c ; "rver"
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        ldx #$1c                    ; 
                        ldy HI_9612                 ; 
                        beq B_7068                  ; 
B_7059                  lda #$71                    ; 
                        sta BH_Scrn_Status + $03c0,x; 
                        
                        lda #LT_GREEN               ; 
                        sta COLORAM + $03c0,x       ; 
                        
                        inx                         ; 
                        inx                         ; 
                        dey                         ; 
                        bne B_7059                  ; 
B_7068                  cpx #$24                    ; 
                        bne B_706d                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_706d                  lda #$20                    ; 
                        sta BH_Scrn_Status + $03c0,x; 
                        inx                         ; 
                        jmp B_7068                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ChapPlaneShootout     Does    : Chapter: Plane shootout
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ChapPlaneShootout       jsr BL_ScreenStatusSave     ; 
                        jsr BL_ScreenStatusGetReady ; 
                        jsr BL_ScreenStatusRestore  ; 
                        
                        ldx #<ScreenDataOpenSea     ; 
                        ldy #>ScreenDataOpenSea     ; 
                        jsr BL_ScreenGraphicInit    ; Init game screen data - Sea battle (Planes)
                        jsr HI_7500                 ; 
                        
                        lda #$00                    ; 
                        jsr S_8d94                  ; 
                        
                        ldx #$03                    ; 
                        jsr BL_SpriteDataCopyInit   ; 
                        jsr S_70f6                  ; 
                        jsr LO_2d62                 ; 
                        beq B_70a0                  ; 
                        
HI_709c                 equ * + $01                 ; 
                        lda #$0a                    ; 
                        jmp J_70a2                  ; 
                        
HI_70a1                 equ * + $01                 ; 
B_70a0                  lda #$1e                    ; 
J_70a2                  sta HI_960d                 ; 
                        jsr S_7983                  ; 
                        
                        lda #$b5                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$00                    ; 
                        jsr S_8e0b                  ; 
.PlaneShootOut          jsr S_8e30                  ; 
                        jsr SimpleRTS               ; 
                        jsr SimpleRTS               ; 
                        jsr CannonPlayerMove        ; 
                        jsr CannonPlayerFire        ; 
                        jsr BL_GetSprtSprtCollReg   ; sprite/sprite collision
                        jsr S_7257                  ; 
                        jsr LO_3a5d                 ; 
                        jsr S_8fae                  ; 
                        jsr LO_21ab                 ; 
                        bne B_70d5                  ; 
                        
                        jmp LO_2c4b                 ; 
                        
B_70d5                  jsr S_73a5                  ; 
                        jsr S_73fd                  ; 
                        jsr S_742f                  ; 
                        jsr LO_235e                 ; 
                        jsr LO_3a71                 ; 
                        jsr BL_ScreenStatusShowShips; 
                        jsr LO_37e2                 ; 
                        jsr LO_381e                 ; 
                        jsr S_9062                  ; 
                        
                        jmp LO_2d2c                 ; 
                        
HI_70f3                 equ *                       ; 
ChapPlaneShootoutX      jmp .PlaneShootOut          ; comes back here
; -------------------------------------------------------------------------------------------------------------- ;
; S_70f6                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_70f6                  subroutine                  ; 
                        jsr BL_GameInit             ; 
                        
                        lda #$01                    ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        jsr S_8dfe                  ; 
                        jsr LO_206c                 ; 
                        lda #$00                    ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta HI_961e                 ; 
                        sta T_972d                  ; 
                        jsr LO_1fef                 ; 
                        jsr S_9594                  ; 
                        lda #$0a                    ; 
                        sta HI_972a                 ; 
                        lda #$01                    ; 
                        sta T_961f                  ; 
                        lda #$64                    ; 
                        sta HI_9628                 ; 
                        lda #$70                    ; 
                        jsr S_8e54                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonPlayerMove      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonPlayerMove        subroutine                  ; 
                        lda HI_96b0                 ; 
                        bne B_7186                  ; 
                        
                        inc HI_96b0                 ; 
                        
                        lda #CIA_Joy_Le             ; .....#..
                        bit TabJoysticAction        ; 
                        beq B_7166                  ; 
                        
                        jsr BL_ClearDirInJoyAction  ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$01                    ; 
                        bne B_7150                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$18                    ; 
                        beq B_7186                  ; 
                        
B_7150                  lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$01                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs B_7186                  ; 
                        
J_715b                  lda #$01                    ; 
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp B_7186                  ; 
                        
B_7166                  lda #CIA_Joy_Ri             ; ....#...
                        bit TabJoysticAction        ; 
                        beq B_7186                  ; 
                        
                        jsr BL_ClearDirInJoyAction  ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$01                    ; 
                        beq B_717e                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$40                    ; 
                        beq B_7186                  ; 
                        
B_717e                  inc SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bne B_7186                  ; 
                        
                        jmp J_715b                  ; 
                        
B_7186                  lda HI_96c0                 ; 
                        beq B_718c                  ; 
                        
                        rts                         ; 
                        
B_718c                  inc HI_96c0                 ; 
                        
                        lda #CIA_Joy_Do             ; ......#.
                        bit TabJoysticAction        ; 
                        beq B_71a6                  ; 
                        
                        jsr BL_ClearDirInJoyAction  ; 
                        
                        lda HI_961b                 ; 
                        cmp #$20                    ; 
                        beq B_71ba                  ; 
                        
                        dec HI_961b                 ; 
                        jmp B_71ba                  ; 
                        
B_71a6                  lda #CIA_Joy_Up             ; .......#
                        bit TabJoysticAction        ; 
                        beq B_71ba                  ; 
                        
                        jsr BL_ClearDirInJoyAction  ; 
                        
                        lda HI_961b                 ; 
                        cmp #$99                    ; 
                        beq B_71ba                  ; 
                        
                        inc HI_961b                 ; 
                        
B_71ba                  lda HI_961b                 ; 
                        sec                         ; 
                        sbc #$20                    ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        clc                         ; 
                        adc T_961a                  ; 
                        sta BH_SpritePointer00      ; 
                        
CannonPlayerMoveX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonPlayerFire      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonPlayerFire        subroutine                  ; 
                        lda #CIA_Joy_Fi             ; ...#....
                        bit TabJoysticAction        ; 
                        bne B_71d3                  ; 
                        
B_71d2                  rts                         ; 
                        
B_71d3                  jsr BL_ClearDirInJoyAction  ; 
                        
                        lda HI_961e                 ; 
                        bne B_71d2                  ; 
                        
                        lda HI_972a                 ; 
                        beq B_71d2                  ; 
                        
                        ldx T_961f                  ; 
                        lda HI_9718,x               ; 
                        bne B_71d2                  ; 
                        
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$ba                    ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        sec                         ; 
                        sbc HI_961b                 ; 
                        sta HI_9620,x               ; 
                        
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_720a                  ; 
                        
                        jsr S_8dd5                  ; 
                        jmp J_720d                  ; 
                        
B_720a                  jsr S_8ddf                  ; 
                        
J_720d                  lda HI_9628                 ; 
                        sta BH_SpritePointers,x     ; 
                        
                        lda #$00                    ; 
                        sta GR_bed0,x               ; 
                        
                        cpx #$01                    ; 
                        bne B_7221                  ; 
                        
                        lda #$02                    ; 
                        jmp J_7223                  ; 
                        
B_7221                  lda #$01                    ; 
J_7223                  sta T_961f                  ; 
                        lda #$01                    ; 
                        sta HI_9718,x               ; 
                        jsr LO_34f9                 ; 
                        
                        jsr LO_2256                 ; 
                        jsr LO_3a53                 ; 
                        jsr S_7242                  ; 
                        
                        lda #$01                    ; 
                        sta HI_961e                 ; 
                        
                        lda #$00                    ; 
                        sta T_9640                  ; 
                        
CannonPlayerFireX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7242                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7242                  subroutine                  ; 
                        jmp J_8dbf                  ; 
                        clc                         ; 
                        adc #$02                    ; 
                        sta BH_SpritePointer00      ; 
                        
J_724b                  lda #$0a                    ; 
                        nop                         ; 
                        sta HI_9698                 ; 
                        lda #$01                    ; 
                        sta HI_96c0                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7257                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7257                  subroutine                  ; 
                        ldx #$02                    ; 
B_7259                  lda HI_9718,x               ; 
                        beq B_72b1                  ; 
                        lda HI_96b0,x               ; 
                        bne B_72b1                  ; 
                        inc HI_96b0,x               ; 
                        inc GR_bed0,x               ; 
                        lda GR_bed0,x               ; 
                        cmp #$10                    ; 
                        bne B_7275                  ; 
                        lda #$00                    ; 
                        sta HI_961e                 ; 
B_7275                  lda GR_bed0,x               ; 
                        cmp #$1e                    ; 
                        beq B_72b5                  ; 
                        lda HI_9628                 ; 
                        clc                         ; 
U_7281                  equ * + $01                 ; 
                        adc #$09                    ; 
                        cmp BH_SpritePointers,x     ; 
                        beq B_7292                  ; 
                        lda GR_bed0,x               ; 
                        lsr a                       ; 
                        clc                         ; 
                        adc HI_9628                 ; 
                        sta BH_SpritePointers,x     ; 
B_7292                  lda HI_9620,x               ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        jsr S_8deb                  ; 
                        lda HI_9620,x               ; 
                        sec                         ; 
                        sbc HI_9729                 ; 
                        sta HI_9620,x               ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc HI_9729                 ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
B_72b1                  dex                         ; 
                        bne B_7259                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_72b5                  lda #$00                    ; 
                        sta HI_9718,x               ; 
                        jsr LO_3503                 ; 
                        lda #$01                    ; 
                        sta T_9640                  ; 
                        jmp B_72b1                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_72c5                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_72c5                  subroutine                  ; 
                        ldx #$05                    ; 
B_72c7                  jmp J_8f93                  ; 
J_72ca                  cmp #$04                    ; 
                        bcs B_72d4                  ; 
J_72ce                  inx                         ; 
                        cpx #$08                    ; 
                        bne B_72c7                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_72d4                  jmp J_8fd0                  ; 
J_72d7                  bit TabSprtSprtCollReg      ; 
                        bne B_72e4                  ; 
                        lda #$10                    ; 
                        bit TabSprtSprtCollReg      ; 
                        bne B_72e4                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_72e4                  stx HI_9740                 ; 
                        nop                         ; 
                        ldx #$01                    ; 
B_72ea                  jsr LO_350f                 ; 
                        bit TabSprtSprtCollReg      ; 
                        bne B_72f9                  ; 
B_72f2                  inx                         ; 
                        cpx #$03                    ; 
                        bne B_72ea                  ; 
                        nop                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_72f9                  lda GR_bed0,x               ; 
                        cmp #$12                    ; 
                        bcc B_72f2                  ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        bcs B_7311                  ; 
                        eor #$ff                    ; 
                        clc                         ; 
                        adc #$01                    ; 
B_7311                  cmp #$08                    ; 
                        bcs B_72f2                  ; 
                        jsr S_8f9f                  ; 
                        jmp J_7320                  ; 
                        lda #$00                    ; 
                        sta HI_9718,x               ; 
J_7320                  jsr LO_3778                 ; 
                        dec HI_960d                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7327                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7327                  subroutine                  ; 
                        ldx HI_9740                 ; 
                        lda #$00                    ; 
                        jsr S_8fe9                  ; 
                        sta T_979c                  ; 
                        jsr S_8fb5                  ; 
                        sta T_9724                  ; 
                        jsr LO_350f                 ; 
                        ora #$10                    ; 
                        ora SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$08                    ; 
                        sta SPMC0                   ; VIC($D025) Sprite Multicolor Register 0
                        lda #$00                    ; 
                        sta SPMC1                   ; VIC($D026) Sprite Multicolor Register 1
                        lda #$07                    ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        lda #$89                    ; 
                        sta BH_SpritePointers,x     ; 
                        lda #$8a                    ; 
                        sta BH_SpritePointer04      ; 
                        lda #$10                    ; 
                        sta T_96ab                  ; 
                        lda #$01                    ; 
                        sta T_96d3                  ; 
                        sta HI_972b                 ; 
                        jsr LO_2050                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7370                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7370                  subroutine                  ; 
                        lda HI_972b                 ; 
                        bne B_7376                  ; 
                        
B_7375                  rts                         ; 
                        
B_7376                  lda T_96d3                  ; 
                        bne B_7375                  ; 
                        
                        ldx #$04                    ; 
                        jsr LO_3503                 ; 
                        
                        ldx HI_9740                 ; 
                        jsr LO_3503                 ; 
                        jsr LO_350f                 ; 
                        
                        ora #$10                    ; 
                        eor #$ff                    ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$00                    ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        sta HI_972b                 ; 
                        jsr S_8e43                  ; 
                        
                        sta HI_9718,x               ; 
                        sta T_971c                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_73a5                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_73a5                  subroutine                  ; 
                        lda HI_972c                 ; 
                        beq B_73ab                  ; 
                        
B_73aa                  rts                         ; 
                        
B_73ab                  lda BH_SpritePointer04      ; 
                        cmp #$50                    ; 
                        bne B_73aa                  ; 
                        
                        cmp #$51                    ; 
                        bcs B_73aa                  ; 
                        
                        lda SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$0c                    ; 
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs B_73cc                  ; 
                        
B_73c1                  lda #$f7                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp J_73db                  ; 
                        
B_73cc                  lda #$10                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_73c1                  ; 
                        
                        lda #$08                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
J_73db                  lda SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        clc                         ; 
                        adc #$0b                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #$01                    ; 
                        sta T_971b                  ; 
                        
                        ldx #$03                    ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$01                    ; 
                        sta HI_96b3                 ; 
                        sta T_96db                  ; 
                        sta HI_968b                 ; 
                        jsr S_9006                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_73fd                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_73fd                  subroutine                  ; 
                        lda HI_972c                 ; 
                        cmp #$01                    ; 
                        beq B_7405                  ; 
B_7404                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7405                  lda HI_96b3                 ; 
                        bne B_7404                  ; 
                        inc HI_96b3                 ; 
                        lda SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        cmp #$b4                    ; 
                        bcs B_741b                  ; 
                        clc                         ; 
                        adc #$04                    ; 
                        jsr S_901f                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_741b                  dec HI_972c                 ; 
                        lda #$00                    ; 
                        sta T_971b                  ; 
                        ldx #$03                    ; 
                        jsr LO_3503                 ; 
                        jsr SimpleRTS               ; 
                        inc T_972d                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_742f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_742f                  subroutine                  ; 
                        lda T_9728                  ; 
                        beq B_7435                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7435                  jsr S_9040                  ; 
                        jsr LO_219e                 ; 
                        nop                         ; 
                        nop                         ; 
                        lda T_972d                  ; 
                        
HI_7441                 equ * + $01                 ; 
                        cmp #$14                    ; 
                        beq B_7445                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7445                  jsr S_9059                  ; 
                        dec TabPlayerLives          ; 
                        lda TabPlayerLives          ; 
                        bne B_745d                  ; 
                        jsr LO_39b6                 ; 
                        lda #$00                    ; 
                        jmp LO_2c56                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_7458                 pla                         ; 
                        pla                         ; 
                        pla                         ; 
                        pla                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_745d                  nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$00                    ; 
                        sta T_972d                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda #$00                    ; 
                        lda #$00                    ; 
                        sta HI_971d                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_7471                 lda TabGameMode             ; 
                        bne B_7477                  ; 
                        
                        rts                         ; 
                        
B_7477                  lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$40                    ; 
                        bne B_7486                  ; 
                        
                        jsr BL_InitTOD              ; 
                        
                        pla                         ; 
                        pla                         ; 
                        jmp ChapShipShootout        ; 
                        
B_7486                  ldx #$05                    ; 
B_7488                  lda HI_9720,x               ; 
                        cmp #$04                    ; 
                        bcs B_7495                  ; 
                        
                        inx                         ; 
                        cpx #$08                    ; 
                        bne B_7488                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7495                  jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        
                        lda HI_961b                 ; 
                        cmp SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq B_74af                  ; 
                        bcc B_74aa                  ; 
                        
                        lda #CIA_Joy_Do             ; 
                        sta TabJoysticAction        ; 
                        
                        jmp B_74af                  ; 
                        
B_74aa                  lda #CIA_Joy_Up             ; 
                        sta TabJoysticAction        ; 
                        
B_74af                  lda #$10                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_74b8                  ; 
                        
                        lda #$01                    ; 
B_74b8                  sta T_9627                  ; 
                        
                        lda #$01                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta T_9625                  ; 
                        
                        lda SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta T_9626                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta T_9624                  ; 
                        
                        jsr S_74f2                  ; 
                        beq B_74e9                  ; 
                        bcs B_74e1                  ; 
                        
                        lda #CIA_Joy_Le             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
                        jmp B_74e9                  ; 
                        
B_74e1                  lda #CIA_Joy_Ri             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
B_74e9                  lda #CIA_Joy_Fi             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_74f2                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_74f2                  subroutine                  ; 
                        ldy #$03                    ; 
B_74f4                  dey                         ; 
                        beq B_74ff                  ; 
                        lda T_9625,y                ; 
                        cmp T_9623,y                ; 
                        beq B_74f4                  ; 
B_74ff                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HI_7500               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HI_7500                 subroutine                  ; 
                        lda #$ff                    ; flag: blank
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$16                    ; 
                        ldx #<TabTextStatusEndOfTxt ; 
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
                        ldy #$18                    ; 
                        ldx #<TabTextStatusEndOfTxt ; 
                        jsr BL_ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        ldx #$07                    ; 
B_7522                  lda HI_9718,x               ; 
                        bne B_752a                  ; 
                        jsr S_756a                  ; 
B_752a                  lda HI_9720,x               ; 
                        bne B_7532                  ; 
                        jsr S_75d4                  ; 
B_7532                  lda HI_9720,x               ; 
                        cmp #$01                    ; 
                        bne B_753c                  ; 
                        jsr S_75f8                  ; 
B_753c                  lda HI_9720,x               ; 
                        cmp #$02                    ; 
                        bne B_7546                  ; 
                        jsr S_7619                  ; 
B_7546                  lda HI_9720,x               ; 
                        cmp #$03                    ; 
                        bne B_7550                  ; 
                        jsr S_763a                  ; 
B_7550                  lda HI_9720,x               ; 
                        cmp #$04                    ; 
                        bne B_755a                  ; 
                        jsr S_76cc                  ; 
B_755a                  lda HI_9720,x               ; 
                        cmp #$05                    ; 
                        bne B_7564                  ; 
                        jsr S_776d                  ; 
B_7564                  dex                         ; 
                        cpx #$04                    ; 
                        bne B_7522                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_756a                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_756a                  subroutine                  ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda #$a8                    ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$8c                    ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        lda #$00                    ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        lda YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        and #$0f                    ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        lda XXPAND                  ; VIC($D01D) Sprite Double Height
                        and #$0f                    ; 
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        lda #$40                    ; 
                        sta BH_SpritePointers,x     ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$ff                    ; 
                        sta HI_9718,x               ; 
                        lda #$10                    ; 
                        sta HI_96d8,x               ; 
                        lda #$04                    ; 
                        sta HI_9700,x               ; 
                        lda #$02                    ; 
                        sta HI_9658,x               ; 
                        lda #$38                    ; 
                        sta HI_9708,x               ; 
                        sta HI_96e8,x               ; 
                        lda #$01                    ; 
                        sta HI_9678,x               ; 
                        lda #$02                    ; 
                        sta HI_9660,x               ; 
                        lda #$00                    ; 
                        sta HI_9668,x               ; 
                        lda #$00                    ; 
                        sta GR_bed0,x               ; 
                        lda #$60                    ; 
                        sta HI_96f8,x               ; 
                        lda #$00                    ; 
                        sta HI_9680,x               ; 
                        lda #$00                    ; 
                        sta HI_9720,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_75d4                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_75d4                  subroutine                  ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$60                    ; 
                        bcs B_75f7                  ; 
                        lda #$ff                    ; 
                        sta HI_9700,x               ; 
                        lda #$03                    ; 
                        sta HI_9658,x               ; 
                        lda #$40                    ; 
                        sta HI_9710,x               ; 
                        lda #$01                    ; 
                        sta HI_9668,x               ; 
                        lda #$01                    ; 
                        sta HI_9720,x               ; 
B_75f7                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_75f8                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_75f8                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$02                    ; 
                        bne B_7618                  ; 
                        lda #$10                    ; 
                        sta HI_9700,x               ; 
                        lda #$04                    ; 
                        sta HI_9658,x               ; 
                        lda #$02                    ; 
                        sta HI_9720,x               ; 
                        lda #$03                    ; 
                        sta HI_9708,x               ; 
                        lda #$02                    ; 
                        sta HI_9660,x               ; 
B_7618                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7619                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7619                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$05                    ; 
                        bne B_7639                  ; 
                        lda #$41                    ; 
                        sta BH_SpritePointers,x     ; 
                        lda #$78                    ; 
                        sta HI_9700,x               ; 
                        lda #$05                    ; 
                        sta HI_9658,x               ; 
                        lda #$1c                    ; 
                        sta HI_9710,x               ; 
                        lda #$03                    ; 
                        sta HI_9720,x               ; 
B_7639                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_763a                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_763a                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$0b                    ; 
                        beq B_7648                  ; 
                        clc                         ; 
                        adc #$3c                    ; 
                        sta BH_SpritePointers,x     ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7648                  jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$0c                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc B_7664                  ; 
                        lda #$10                    ; 
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
B_7664                  lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$0c                    ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs B_7678                  ; 
                        jsr LO_350f                 ; 
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
B_7678                  nop                         ; 
                        lda #$47                    ; 
                        sta BH_SpritePointers,x     ; 
                        lda #$48                    ; 
                        sta BH_SpritePointer04      ; 
                        
                        lda HI_9700,x               ; 
                        sta HI_9704                 ; 
                        lda HI_9708,x               ; 
                        sta HI_970c                 ; 
                        lda HI_9710,x               ; 
                        sta HI_9714                 ; 
                        lda HI_9658,x               ; 
                        sta HI_965c                 ; 
                        lda HI_9660,x               ; 
                        sta HI_9664                 ; 
                        lda HI_9668,x               ; 
                        sta HI_966c                 ; 
                        lda HI_9670,x               ; 
                        sta HI_9674                 ; 
                        lda HI_9678,x               ; 
                        sta HI_967c                 ; 
                        lda HI_9680,x               ; 
                        sta T_9684                  ; 
                        lda #$04                    ; 
                        sta HI_9720,x               ; 
                        
                        lda #$01                    ; 
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$00                    ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_76cc                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_76cc                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$10                    ; 
                        beq B_76e3                  ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #$31                    ; 
                        sta BH_SpritePointers,x     ; 
                        adc #$01                    ; 
                        sta BH_SpritePointer04      ; 
                        jsr S_77c2                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_76e3                  cpx #$07                    ; 
                        bne B_7714                  ; 
                        lda #$02                    ; 
                        sta T_9707                  ; 
                        sta HI_9704                 ; 
                        lda #$02                    ; 
                        sta T_970f                  ; 
                        sta HI_970c                 ; 
                        lda #$01                    ; 
                        sta T_965f                  ; 
                        sta HI_965c                 ; 
                        lda #$01                    ; 
                        sta T_9667                  ; 
                        sta HI_9664                 ; 
                        lda #$5d                    ; 
                        sta BH_SpritePointer07      ; 
                        lda #$5e                    ; 
                        sta BH_SpritePointer04      ; 
                        jmp J_7767                  ; 
B_7714                  cpx #$06                    ; 
                        bne B_7735                  ; 
                        lda #$02                    ; 
                        sta T_970e                  ; 
                        sta HI_970c                 ; 
                        lda #$01                    ; 
                        sta T_9666                  ; 
                        sta HI_9664                 ; 
                        lda #$51                    ; 
                        sta BH_SpritePointer06      ; 
                        lda #$52                    ; 
                        sta BH_SpritePointer04      ; 
                        jmp J_7767                  ; 
B_7735                  lda #$02                    ; 
                        sta HI_9705                  ; 
                        sta HI_9704                 ; 
                        lda #$ff                    ; 
                        sta T_9675                  ; 
                        sta HI_9674                 ; 
                        lda #$02                    ; 
                        sta T_970d                  ; 
                        sta HI_970c                 ; 
                        lda #$01                    ; 
                        sta HI_965d                 ; 
                        sta HI_965c                 ; 
                        lda #$01                    ; 
                        sta T_9665                  ; 
                        sta HI_9664                 ; 
                        lda #$57                    ; 
                        sta BH_SpritePointer05      ; 
                        lda #$58                    ; 
                        sta BH_SpritePointer04      ; 
J_7767                  lda #$05                    ; 
                        sta HI_9720,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_776d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_776d                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$13                    ; 
                        bcs B_77a5                  ; 
                        cpx #$07                    ; 
                        bne B_7783                  ; 
                        asl a                       ; 
                        adc #$3d                    ; 
                        sta BH_SpritePointer07      ; 
                        ldy #$3e                    ; 
                        jmp J_779a                  ; 
B_7783                  cpx #$06                    ; 
                        bne B_7792                  ; 
                        asl a                       ; 
                        adc #$31                    ; 
                        sta BH_SpritePointer06      ; 
                        ldy #$32                    ; 
                        jmp J_779a                  ; 
B_7792                  asl a                       ; 
                        adc #$37                    ; 
                        sta BH_SpritePointer05      ; 
                        ldy #$38                    ; 
J_779a                  nop                         ; 
                        clc                         ; 
                        adc #$01                    ; 
                        sta BH_SpritePointer04      ; 
                        jsr S_77c2                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_77a5                  jsr LO_3503                 ; 
                        
                        lda #$ff                    ; 
                        sta HI_9718,x               ; 
                        
                        lda #$ef                    ; ###.####
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        inx                         ; 
                        cpx #$08                    ; 
                        bne B_77bc                  ; 
                        
                        ldx #$05                    ; 
B_77bc                  lda #$00                    ; 
                        sta HI_9718,x               ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_77c2                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_77c2                  subroutine                  ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$18                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc B_77d8                  ; 
                        lda #$10                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
B_77d8                  lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        ldx #$07                    ; 
J_77e1                  lda HI_9658,x               ; 
                        bne B_77ee                  ; 
                        lda #$00                    ; 
                        sta HI_9670,x               ; 
                        jmp J_7841                  ; 
B_77ee                  cmp #$01                    ; 
                        bne B_77fb                  ; 
                        lda HI_9700,x               ; 
                        sta HI_96d8,x               ; 
                        jmp J_7841                  ; 
B_77fb                  cmp #$02                    ; 
                        bne B_7817                  ; 
                        lda #$ff                    ; 
                        sta HI_9670,x               ; 
J_7804                  lda HI_96b8,x               ; 
                        bne J_7841                  ; 
                        lda HI_9700,x               ; 
                        cmp HI_96d8,x               ; 
                        beq J_7841                  ; 
                        dec HI_96d8,x               ; 
                        jmp J_7841                  ; 
B_7817                  cmp #$03                    ; 
                        bne B_782e                  ; 
J_781b                  lda HI_96b8                 ; 
                        bne J_7841                  ; 
                        lda HI_9700,x               ; 
                        cmp HI_96d8,x               ; 
                        beq J_7841                  ; 
                        inc HI_96d8,x               ; 
                        jmp J_7841                  ; 
B_782e                  cmp #$04                    ; 
                        bne B_783a                  ; 
                        lda #$01                    ; 
                        sta HI_9670,x               ; 
                        jmp J_7804                  ; 
B_783a                  cmp #$05                    ; 
                        bne B_784b                  ; 
                        jmp J_781b                  ; 
J_7841                  lda HI_96b8                 ; 
                        bne B_784b                  ; 
                        lda #$01                    ; 
                        sta HI_96b8,x               ; 
B_784b                  lda HI_9660,x               ; 
                        bne B_7858                  ; 
                        lda #$00                    ; 
                        sta HI_9678,x               ; 
                        jmp J_78ab                  ; 
B_7858                  cmp #$01                    ; 
                        bne B_7865                  ; 
                        lda HI_9708,x               ; 
                        sta HI_96e8,x               ; 
                        jmp J_78ab                  ; 
B_7865                  cmp #$02                    ; 
                        bne B_7881                  ; 
                        lda #$01                    ; 
                        sta HI_9678,x               ; 
J_786e                  lda HI_96c8                 ; 
                        bne J_78ab                  ; 
                        lda HI_9708,x               ; 
                        cmp HI_96e8,x               ; 
                        beq J_78ab                  ; 
                        dec HI_96e8,x               ; 
                        jmp J_78ab                  ; 
B_7881                  cmp #$03                    ; 
                        bne B_7898                  ; 
J_7885                  lda HI_96c8                 ; 
                        bne J_78ab                  ; 
                        lda HI_96e8,x               ; 
                        cmp HI_9708,x               ; 
                        beq J_78ab                  ; 
                        inc HI_96e8,x               ; 
                        jmp J_78ab                  ; 
B_7898                  cmp #$04                    ; 
                        bne B_78a4                  ; 
                        lda #$ff                    ; 
                        sta HI_9678,x               ; 
                        jmp J_786e                  ; 
B_78a4                  cmp #$05                    ; 
                        bne B_78b5                  ; 
                        jmp J_7885                  ; 
J_78ab                  lda HI_96c8                 ; 
                        bne B_78b5                  ; 
                        lda #$01                    ; 
                        sta HI_96c8,x               ; 
B_78b5                  lda HI_9668,x               ; 
                        bne B_78c7                  ; 
                        lda #$00                    ; 
                        sta HI_9680,x               ; 
                        lda #$3c                    ; 
                        sta HI_96f8,x               ; 
                        jmp J_78d6                  ; 
B_78c7                  cmp #$01                    ; 
                        bne J_78d6                  ; 
                        lda #$01                    ; 
                        sta HI_9680,x               ; 
                        lda HI_9710,x               ; 
                        sta HI_96f8,x               ; 
J_78d6                  dex                         ; 
                        bmi B_78dc                  ; 
                        jmp J_77e1                  ; 
B_78dc                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ChapShipShootout      Does    : Chapter: Ship shootout
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ChapShipShootout        jsr BL_ScreenStatusSave     ; 
                        jsr BL_ScreenStatusGetReady ; 
                        jsr BL_ScreenStatusRestore  ; 
                        
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        jsr S_9096                  ; 
                        
                        ldx #$04                    ; 
                        jsr BL_SpriteDataCopyInit   ; 
                        jsr S_794d                  ; 
                        jsr S_7983                  ; 
                        
                        lda #$b5                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        jsr S_8da6                  ; 
                        
                        lda #$03                    ; 
                        sta T_972e                  ; 
                        
                        jsr S_95db                  ; 
J_790a                  jsr S_79ae                  ; 
                        jsr S_91ea                  ; 
                        jsr S_7a08                  ; 
                        jsr CannonPlayerMove        ; 
                        jsr CannonPlayerFire        ; 
                        
                        lda #$01                    ; 
                        sta T_961f                  ; 
                        
                        jsr S_7b46                  ; 
                        jsr LO_3a5d                 ; 
                        jsr S_9320                  ; 
                        bne B_792c                  ; 
                        
                        jmp J_95a5                  ; 
                        
B_792c                  jsr S_8061                  ; 
                        jsr BL_ScreenStatusShowScore; 
                        jsr S_7f28                  ; 
                        jsr LO_2163                 ; 
                        jsr S_9118                  ; 
                        jsr S_920f                  ; 
                        jsr S_7fd8                  ; 
                        jsr LO_381e                 ; 
                        jsr S_924d                  ; 
                        
                        jmp LO_2d35                 ; 
                        
HI_794a                 equ *                       ; 
ChapShipShootoutX       jmp J_790a                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_794d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_794d                  subroutine                  ; 
                        jsr BL_GameInit             ; 
                        
                        lda #$9c                    ; 
                        sta HI_972f                 ; 
                        lda #$41                    ; 
                        jsr LO_1f76                 ; 
                        lda #$4d                    ; 
                        sta T_961a                  ; 
                        
                        lda #$00                    ; 
                        jsr S_926a                  ; 
                        
                        lda #$10                    ; 
                        sta T_96db                  ; 
                        jsr S_959e                  ; 
                        lda #$20                    ; 
                        bit HI_9619                 ; 
                        beq B_7978                  ; 
                        lda #$01                    ; 
                        jmp J_797a                  ; 
B_7978                  lda #$00                    ; 
J_797a                  sta T_9738                  ; 
                        lda #$0a                    ; 
                        jsr LO_207e                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7983                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7983                  subroutine                  ; 
                        lda T_961a                  ; 
                        clc                         ; 
                        adc #$08                    ; 
                        sta BH_SpritePointer00      ; 
                        
                        lda #$60                    ; 
                        sta HI_961b                 ; 
                        
                        lda #$a0                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$ac                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$fe                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$01                    ; 
                        sta HI_96d8                 ; 
                        
U_79a9                  equ * + $01                 ; 
                        lda #$01                    ; 
                        jsr S_8d9d                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_79ae                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_79ae                  subroutine                  ; 
                        lda HI_972c                 ; 
                        beq B_79b4                  ; 
B_79b3                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_79b4                  lda HI_96b3                 ; 
                        bne B_79b3                  ; 
                        lda #$fb                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda T_972e                  ; 
                        cmp #$01                    ; 
                        bne B_79cc                  ; 
                        lda #$33                    ; 
                        bne B_79ea                  ; 
B_79cc                  cmp #$02                    ; 
                        bne B_79d4                  ; 
                        lda #$6e                    ; 
                        bne B_79ea                  ; 
B_79d4                  cmp #$03                    ; 
                        bne B_79dc                  ; 
                        lda #$ff                    ; 
                        bne B_79ea                  ; 
B_79dc                  cmp #$04                    ; 
                        bne B_79b3                  ; 
                        lda #$04                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #$32                    ; 
B_79ea                  sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$01                    ; 
                        sta HI_9720                 ; 
                        sta HI_972c                 ; 
                        sta T_971b                  ; 
                        lda #$8c                    ; 
                        jsr LO_215c                 ; 
                        lda #$5d                    ; 
                        sta BH_SpritePointer02      ; 
                        lda #$00                    ; 
                        jsr S_91ff                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7a08                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7a08                  subroutine                  ; 
                        lda HI_972c                 ; 
                        cmp #$01                    ; 
                        beq B_7a10                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7a10                  lda HI_9720                 ; 
                        cmp #$01                    ; 
                        beq B_7a27                  ; 
                        cmp #$02                    ; 
                        beq B_7a55                  ; 
                        cmp #$03                    ; 
                        beq B_7a9c                  ; 
                        cmp #$04                    ; 
                        bne B_7a26                  ; 
                        jmp J_7ac7                  ; 
B_7a26                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7a27                  lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        cmp #$18                    ; 
                        bcc B_7a40                  ; 
                        lda T_96c3                  ; 
                        bne B_7a26                  ; 
                        inc T_96c3                  ; 
                        lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$02                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7a40                  lda #$02                    ; 
                        sta HI_9720                 ; 
                        lda #$d0                    ; 
                        sta T_969b                  ; 
                        lda #$01                    ; 
                        sta T_96c3                  ; 
                        lda #$5f                    ; 
                        sta BH_SpritePointer02      ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7a55                  lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        cmp HI_972f                 ; 
                        bcs B_7a6c                  ; 
                        lda T_96c3                  ; 
                        bne B_7a26                  ; 
                        inc T_96c3                  ; 
                        lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        jsr S_9208                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7a6c                  lda HI_972f                 ; 
                        cmp #$b0                    ; 
                        bcc B_7a76                  ; 
                        jmp J_7b0b                  ; 
B_7a76                  lda #$03                    ; 
                        sta HI_9720                 ; 
                        lda #$02                    ; 
                        sta T_96eb                  ; 
                        lda #$67                    ; 
                        sta BH_SpritePointer02      ; 
                        lda #$04                    ; 
                        ora YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        lda #$01                    ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$15                    ; 
                        jsr LO_216d                 ; 
B_7a9b                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7a9c                  lda BH_SpritePointer02      ; 
                        cmp #$6b                    ; 
                        beq B_7ab9                  ; 
                        lda T_96c3                  ; 
                        bne B_7a9b                  ; 
                        lda T_96eb                  ; 
                        asl a                       ; 
                        sta T_96eb                  ; 
                        sta T_969b                  ; 
                        inc T_96c3                  ; 
                        inc BH_SpritePointer02      ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7ab9                  lda #$04                    ; 
                        sta HI_9720                 ; 
                        lda #$0e                    ; 
                        sta T_96eb                  ; 
                        sta T_969b                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_7ac7                  lda T_96c3                  ; 
                        bne B_7a9b                  ; 
                        lda BH_SpritePointer02      ; 
                        cmp #$71                    ; 
                        beq B_7ae1                  ; 
                        jsr S_9225                  ; 
                        nop                         ; 
                        sta T_969b                  ; 
                        inc T_96c3                  ; 
                        inc BH_SpritePointer02      ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7ae1                  lda #$00                    ; 
                        sta HI_972c                 ; 
                        sta HI_9720                 ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        sta T_971b                  ; 
                        lda #$01                    ; 
                        jsr S_922f                  ; 
                        lda #$fb                    ; 
                        and YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        ldx #$02                    ; 
                        jsr LO_3503                 ; 
                        lda HI_972f                 ; 
                        clc                         ; 
                        
HI_7b06                 equ * + $01                 ; 
                        adc #$04                    ; 
                        jsr S_662e                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_7b0b                  jsr LO_2174                 ; 
                        lda TabPlayerLives          ; 
                        bne B_7b16                  ; 
                        jmp LO_2c9a                 ; 
B_7b16                  jsr S_9059                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jsr S_6697                  ; 
                        lda #$94                    ; 
                        sta HI_972f                 ; 
                        jsr S_92c0                  ; 
B_7b2a                  jmp B_7ae1                  ; 
                        bne B_7b39                  ; 
                        inx                         ; 
                        cpx #$04                    ; 
                        bne B_7b2a                  ; 
                        jmp J_92b0                  ; 
                        nop                         ; 
                        nop                         ; 
B_7b39                  inx                         ; 
                        cpx #$04                    ; 
                        bne B_7b40                  ; 
                        ldx #$00                    ; 
B_7b40                  stx T_972e                  ; 
                        jmp B_7ae1                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7b46                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7b46                  subroutine                  ; 
                        lda T_9719                  ; 
                        bne B_7b4c                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7b4c                  lda #$00                    ; 
                        sta T_971a                  ; 
                        lda T_9640                  ; 
                        bne B_7b5f                  ; 
                        jsr S_9155                  ; 
                        lda #$01                    ; 
                        sta T_9719                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7b5f                  cmp #$01                    ; 
                        bne B_7b90                  ; 
                        ldx #$01                    ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$04                    ; 
                        sta T_96e9                  ; 
                        sta T_9699                  ; 
                        sta T_96c1                  ; 
                        inc T_9640                  ; 
                        lda #$b6                    ; 
                        sec                         ; 
                        sbc HI_961b                 ; 
                        sta T_961d                  ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        sta T_961c                  ; 
                        lda #$a2                    ; 
                        sec                         ; 
                        sbc T_961c                  ; 
                        jsr S_9163                  ; 
B_7b8f                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7b90                  cmp #$02                    ; 
                        bne B_7b8f                  ; 
                        lda T_96c1                  ; 
                        bne B_7b8f                  ; 
                        inc T_9709                  ; 
                        jmp J_7ba6                  ; 
                        ora #$38                    ; 
                        sbc #$02                    ; 
                        sta T_96e9                  ; 
J_7ba6                  inc T_96c1                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        cmp T_961c                  ; 
                        bcc B_7b8f                  ; 
                        jsr S_9179                  ; 
                        beq HI_7bfb                 ; 
                        jmp LO_2d1c                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_7bbc                 sec                         ; 
                        sbc #$0c                    ; 
                        jmp J_91bc                  ; 
J_7bc2                  bcs HI_7bfb                 ; 
J_7bc4                  lda SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$08                    ; 
                        cmp SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc HI_7bfb                 ; 
                        lda T_961d                  ; 
                        cmp #$60                    ; 
                        bne B_7be2                  ; 
                        jsr S_7ca8                  ; 
J_7bd9                  lda #$00                    ; 
                        sta T_9719                  ; 
                        sta T_9640                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7be2                  sec                         ; 
                        sbc #$60                    ; 
                        bcc B_7bed                  ; 
                        jsr S_7ea7                  ; 
                        jmp J_7bd9                  ; 
B_7bed                  eor #$ff                    ; 
                        clc                         ; 
                        adc #$01                    ; 
                        jsr S_7eb7                  ; 
                        jsr S_7f6e                  ; 
                        jmp J_7bd9                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_7bfb                 lda #$02                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_7c5b                  ; 
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$4c                    ; 
                        bcs B_7c23                  ; 
                        lda T_9731                  ; 
                        beq B_7c7c                  ; 
                        lda T_961d                  ; 
                        sec                         ; 
                        sbc #$80                    ; 
                        bne B_7c8b                  ; 
                        lda #$02                    ; 
                        bit TabSprtBackCollReg      ; 
                        beq B_7c7c                  ; 
                        jsr S_7d34                  ; 
                        jmp J_7bd9                  ; 
B_7c23                  cmp #$84                    ; 
                        bcs B_7c41                  ; 
                        lda T_9732                  ; 
                        beq B_7c7c                  ; 
                        lda T_961d                  ; 
                        sec                         ; 
                        sbc #$70                    ; 
                        bne B_7c8b                  ; 
                        lda #$02                    ; 
                        bit TabSprtBackCollReg      ; 
                        beq B_7c7c                  ; 
                        jsr S_7dc9                  ; 
                        jmp J_7bd9                  ; 
B_7c41                  lda T_9733                  ; 
                        beq B_7c7c                  ; 
                        lda T_961d                  ; 
                        sec                         ; 
                        sbc #$8c                    ; 
                        bne B_7c8b                  ; 
                        lda #$02                    ; 
                        bit TabSprtBackCollReg      ; 
                        beq B_7c7c                  ; 
                        jsr S_7e04                  ; 
                        jmp J_7bd9                  ; 
B_7c5b                  lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$0c                    ; 
                        bcc B_7c41                  ; 
                        lda T_9734                  ; 
                        beq B_7c7c                  ; 
                        lda T_961d                  ; 
                        sec                         ; 
                        sbc #$28                    ; 
                        bne B_7c8b                  ; 
                        lda #$02                    ; 
                        bit TabSprtBackCollReg      ; 
                        beq B_7c7c                  ; 
                        
                        jsr S_7e39                  ; 
                        jmp J_7bd9                  ; 
                        
B_7c7c                  lda #$ff                    ; flag: blank
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$16                    ; 
                        ldx #<TabTextStatusByBruce + $0e ; "r"
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        jmp J_7c97                  ; 
                        
B_7c8b                  bcc B_7c9d                  ; 
                        jsr S_7ea7                  ; 
                        lda #$02                    ; 
                        bit TabSprtBackCollReg      ; 
                        bne B_7c9a                  ; 
J_7c97                  jsr S_7f6e                  ; 
B_7c9a                  jmp J_7bd9                  ; 
B_7c9d                  eor #$ff                    ; 
                        clc                         ; 
                        adc #$01                    ; 
                        jsr S_7eb7                  ; 
                        jmp J_7c97                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7ca8                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7ca8                  subroutine                  ; 
                        jsr S_9317                  ; 
                        lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$9c                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        jsr S_7d0b                  ; 
                        ldx #$03                    ; 
                        jsr LO_34f9                 ; 
                        
                        ldx #$04                    ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$0f                    ; 
                        sta T_96dc                  ; 
                        jsr S_9278                  ; 
                        lda #$01                    ; 
                        sta T_96b4                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7cd9                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7cd9                  subroutine                  ; 
                        lda T_96b4                  ; 
                        bne B_7d0a                  ; 
                        
                        inc T_96b4                  ; 
                        
                        inc SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        inc SP6Y                    ; VIC($D00D) Sprite 6 Y-Pos (Bits 0-7)
                        inc SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        
                        lda SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        cmp #$9b                    ; 
                        bne B_7d0a                  ; 
                        
HI_7cf1                 lda #$07                    ; .....###
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        jsr LO_3781                 ; 
                        jsr LO_3787                 ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$df                    ; 
                        and HI_9619                 ; 
                        jsr S_9281                  ; 
B_7d0a                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7d0b                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7d0b                  subroutine                  ; 
                        lda #$75                    ; 
                        sta BH_SpritePointer03      ; 
                        sta BH_SpritePointer04      ; 
                        lda #$e7                    ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$06                    ; 
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        lda #$e7                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #$18                    ; 
                        ora XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7d34                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7d34                  subroutine                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$38                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$8a                    ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #$9a                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        lda #$76                    ; 
                        sta BH_SpritePointer04      ; 
                        jsr S_7d88                  ; 
                        lda #$73                    ; 
                        jsr S_91c7                  ; 
                        sta XT_49e5                 ; 
                        ldx #$01                    ; 
                        jsr S_9301                  ; 
                        lda #$00                    ; 
                        sta T_9731                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7d64                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7d64                  subroutine                  ; 
                        lda T_96b4                  ; 
                        bne B_7d87                  ; 
                        jsr S_91ce                  ; 
                        cmp SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        bne B_7d87                  ; 
                        
                        lda #$e7                    ; ###..###
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        jmp J_7d84                  ; 
                        
                        eor #$ff                    ; 
                        and HI_9619                 ; 
                        sta HI_9619                 ; 
J_7d84                  jsr S_928a                  ; 
B_7d87                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7d88                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7d88                  subroutine                  ; 
                        jsr S_7da1                  ; 
                        
                        lda #$18                    ; ...##...
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$0f                    ; 
                        sta T_96dc                  ; 
                        sta T_968c                  ; 
                        
                        lda #$01                    ; 
                        sta T_96b4                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7da1                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7da1                  subroutine                  ; 
                        lda #$75                    ; 
                        sta BH_SpritePointer03      ; 
                        lda #$e7                    ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$00                    ; 
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        lda #$06                    ; 
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        lda #$e7                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #$e7                    ; 
                        and XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7dc9                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7dc9                  subroutine                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$70                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$8a                    ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #$9b                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        lda #$77                    ; 
                        sta BH_SpritePointer04      ; 
                        jsr S_7d88                  ; 
                        lda #$73                    ; 
                        sta XT_49eb                 ; 
                        sta XT_49ec                 ; 
                        lda #$30                    ; 
                        sta XT_4a12                 ; 
                        sta XT_4a13                 ; 
                        sta XT_4a14                 ; 
                        ldx #$02                    ; 
                        jsr S_9301                  ; 
                        lda #$00                    ; 
                        sta T_9732                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7e04                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7e04                  subroutine                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$00                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$8a                    ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #$9a                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        lda #$78                    ; 
                        sta BH_SpritePointer04      ; 
                        jsr S_7d88                  ; 
                        lda #$73                    ; 
                        sta XT_49fe                 ; 
                        lda #$18                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        ldx #$03                    ; 
                        jsr S_9301                  ; 
                        lda #$00                    ; 
                        sta T_9733                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7e39                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7e39                  subroutine                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$30                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$92                    ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #$a0                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        lda #$79                    ; 
                        sta BH_SpritePointer04      ; 
                        jsr S_7d88                  ; 
                        lda #$18                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #$18                    ; 
                        ora XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        lda #$30                    ; 
                        sta XT_4a2b                 ; 
                        sta XT_4a2c                 ; 
                        sta XT_4a2d                 ; 
                        sta XT_4a2e                 ; 
                        sta XT_4a2f                 ; 
                        ldx #$04                    ; 
                        jsr S_9301                  ; 
                        lda #$00                    ; 
                        sta T_9734                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7e82                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7e82                  subroutine                  ; 
                        lda #$63                    ; 
                        jsr S_92aa                  ; 
                        lda #$08                    ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        
                        lda #RED                    ; 
                        sta TabBackGroundColor      ; 
                        
                        jsr LO_33ea                 ; ResetTOD
                        nop                         ; 
                        nop                         ; 
                        jsr LO_2149                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7e99                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7e99                  subroutine                  ; 
                        lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        beq B_7ea6                  ; 
                        jmp J_92ec                  ; 
                        nop                         ; 
                        nop                         ; 
J_7ea3                  jsr S_929c                  ; 
B_7ea6                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7ea7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7ea7                  subroutine                  ; 
                        jsr S_7ec7                  ; 
                        
                        lda #WHITE                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$1b                    ; 
                        ldx #<TabTextStatusMLong    ; 
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7eb7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7eb7                  subroutine                  ; 
                        jsr S_7ec7                  ; 
                        
                        lda #WHITE                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$1b                    ; 
                        ldx #<TabTextStatusMShort   ; 
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7ec7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7ec7                  subroutine                  ; 
                        jsr S_7efc                  ; 
                        tya                         ; 
                        pha                         ; 
                        txa                         ; 
                        jsr BL_MakeDigit            ; xr=right nibble yr=left nibble
                        sty BH_Scrn_Status + $03d5  ; 
                        pla                         ; 
                        jsr BL_MakeDigit            ; xr=right nibble yr=left nibble
                        stx BH_Scrn_Status + $03d6  ; 
                        sty BH_Scrn_Status + $03d7  ; 
                        lda #$30                    ; 
                        sta BH_Scrn_Status + $03d8  ; 
                        sta BH_Scrn_Status + $03d9  ; 
                        
                        lda #WHITE                  ; 
                        sta COLORAM + $03d5         ; 
                        sta COLORAM + $03d6         ; 
                        sta COLORAM + $03d7         ; 
                        sta COLORAM + $03d8         ; 
                        sta COLORAM + $03d9         ; 
                        
                        lda #$20                    ; 
                        sta BH_Scrn_Status + $03da  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7efc                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7efc                  subroutine                  ; 
                        ldy #$00                    ; 
J_7efe                  sta T_974f                  ; 
                        sec                         ; 
                        sbc #$64                    ; 
                        bcc B_7f0a                  ; 
                        iny                         ; 
                        jmp J_7efe                  ; 
B_7f0a                  tya                         ; 
                        tax                         ; 
                        lda T_974f                  ; 
                        ldy #$00                    ; 
J_7f11                  sta T_974f                  ; 
                        sec                         ; 
                        sbc #$0a                    ; 
                        bcc B_7f1d                  ; 
                        iny                         ; 
                        jmp J_7f11                  ; 
B_7f1d                  tya                         ; 
                        asl a                       ; 
                        asl a                       ; 
                        asl a                       ; 
                        asl a                       ; 
                        clc                         ; 
                        adc T_974f                  ; 
                        tay                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7f28                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7f28                  subroutine                  ; 
                        lda #$b3                    ; 
                        sec                         ; 
                        sbc HI_961b                 ; 
                        clc                         ; 
                        lsr a                       ; 
                        pha                         ; 
                        bcc B_7f38                  ; 
                        
                        lda #$05                    ; 
                        jmp J_7f3a                  ; 
                        
B_7f38                  lda #$00                    ; 
J_7f3a                  jsr BL_MakeDigit            ; xr=right nibble yr=left nibble
                        
                        sty BH_Scrn_Status + $03b1  ; 
                        pla                         ; 
                        jsr S_95d3                  ; 
                        
                        tya                         ; 
                        jsr BL_MakeDigit            ; xr=right nibble yr=left nibble
                        
                        stx BH_Scrn_Status + $03ae  ; 
                        sty BH_Scrn_Status + $03af  ; 
                        
                        lda #$2e                    ; 
                        sta BH_Scrn_Status + $03b0  ; 
                        
                        lda #WHITE                  ; 
                        sta COLORAM + $03ae         ; 
                        sta COLORAM + $03af         ; 
                        sta COLORAM + $03b0         ; 
                        sta COLORAM + $03b1         ; 
                        
                        lda #WHITE                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$1b                    ; 
                        ldx #<TabTextStatusDegElev + $02 ; 
                        jsr BL_ScreenStatusTextOutRow4 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7f6e                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7f6e                  subroutine                  ; 
                        jmp J_9342                  ; 
J_7f71                  cmp #$41                    ; 
                        bcs B_7f7a                  ; 
                        lda #$66                    ; 
                        jmp J_7f85                  ; 
B_7f7a                  cmp #$63                    ; 
                        bcs B_7f83                  ; 
                        lda #$65                    ; 
                        jmp J_7f85                  ; 
B_7f83                  lda #$64                    ; 
J_7f85                  sta BH_SpritePointer03      ; 
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        jsr S_9187                  ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        lda #$02                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_7fa6                  ; 
                        lda #$f7                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp J_7fae                  ; 
B_7fa6                  lda #$08                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
J_7fae                  lda #$01                    ; 
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        lda #$f7                    ; 
                        and YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        lda #$f7                    ; 
                        and XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        lda #$01                    ; 
                        sta T_9739                  ; 
                        lda #$14                    ; 
                        sta HI_968a                 ; 
                        lda #$01                    ; 
                        sta T_96b2                  ; 
                        ldx #$03                    ; 
                        jsr LO_34f9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7fd8                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7fd8                  subroutine                  ; 
                        lda T_9739                  ; 
                        bne B_7fde                  ; 
B_7fdd                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_7fde                  lda T_96b2                  ; 
                        bne B_7fdd                  ; 
                        lda #$00                    ; 
                        sta T_9739                  ; 
                        ldx #$03                    ; 
                        jsr LO_3503                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_7fee                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_7fee                  subroutine                  ; 
                        lda #$a8                    ; 
                        nop                         ; 
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$18                    ; 
                        sta SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$18                    ; 
                        sta SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$8a                    ; 
                        sta SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        sta SP6Y                    ; VIC($D00D) Sprite 6 Y-Pos (Bits 0-7)
                        
HI_8009                 equ * + $01                 ; 
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        ldx #$1f                    ; 
                        txa                         ; 
                        and YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        txa                         ; 
                        and XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        txa                         ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        txa                         ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #$00                    ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        sta SP6COL                  ; VIC($D02D) Color Sprite 6
                        jsr S_90ab                  ; 
                        
                        lda #$e0                    ; ###.....
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        jsr S_90bc                  ; 
                        
                        ldy #$12                    ; 
                        ldx #$0a                    ; 
                        lda #$73                    ; 
B_8042                  sta XT_49e0,y               ; 
                        iny                         ; 
                        dex                         ; 
                        bne B_8042                  ; 
                        ldy #$12                    ; 
                        ldx #$0a                    ; 
                        lda #$30                    ; 
B_804f                  sta XT_4a08,y               ; 
                        iny                         ; 
                        dex                         ; 
                        bne B_804f                  ; 
                        lda #$0f                    ; 
                        sta T_96dd                  ; 
                        lda #$01                    ; 
                        sta T_96b5                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8061                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8061                  subroutine                  ; 
                        lda T_9738                  ; 
                        bne B_8067                  ; 
B_8066                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8067                  lda T_96b5                  ; 
                        bne B_8066                  ; 
                        inc T_96b5                  ; 
                        lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq B_8077                  ; 
                        dec SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
B_8077                  lda SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq B_807f                  ; 
                        dec SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
B_807f                  lda SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq B_8088                  ; 
                        dec SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8088                  lda #$1f                    ; ...#####
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        jsr S_92e0                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8094                 lda TabGameMode             ; 
                        bne B_809a                  ; 
                        
                        rts                         ; 
                        
B_809a                  lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$30                    ; 
                        bne B_80ae                  ; 
                        
                        jsr BL_InitTOD              ; 
                        
                        lda #$03                    ; 
                        sta TabGameMode             ; 
                        
                        pla                         ; 
                        pla                         ; 
                        jmp LO_1fa4                 ; 
                        
B_80ae                  lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_80bd                  ; 
                        
B_80b5                  lda #CIA_Joy_Le             ; 
                        sta TabJoysticAction        ; 
                        jmp J_80cb                  ; 
                        
B_80bd                  lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$63                    ; 
                        beq J_80cb                  ; 
                        bcs B_80b5                  ; 
                        
                        lda #CIA_Joy_Ri             ; 
                        sta TabJoysticAction        ; 
                        
J_80cb                  lda T_961d                  ; 
                        cmp #$60                    ; 
                        beq B_80dc                  ; 
                        bcc B_80e5                  ; 
                        
                        lda #CIA_Joy_Up             ; 
B_80d6                  ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
B_80dc                  lda #CIA_Joy_Fi             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_80e5                  lda #$02                    ; 
                        bne B_80d6                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HI_80e9               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HI_80e9                 subroutine                  ; 
                        lda #CYAN                   ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$18                    ; 
                        ldx #TabTextStatus250mm     ; 
                        jsr BL_ScreenStatusTextOutRow2 ; xr=input text offset  yr=output text offset
                        
                        lda #BROWN                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$1d                    ; 
                        ldx #<TabTextStatusAmmoCube ; 
                        jsr BL_ScreenStatusTextOutRow2 ; xr=input text offset  yr=output text offset
                        
                        lda #WHITE                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$18                    ; 
                        ldx #<TabTextStatusDegElev  ; 
                        jsr BL_ScreenStatusTextOutRow4 ; xr=input text offset  yr=output text offset
                        
                        lda #$ff                    ; flag: blank
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$16                    ; 
                        ldx #<TabTextStatusEndOfTxt ; 
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ChapTanksOnBeach      Does    : Chapter: Tanks on the beach
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ChapTanksOnBeach        subroutine                  ; 
HI_811a                 equ *                       ; 
                        jsr BL_ScreenStatusSave     ; 
                        jsr BL_ScreenStatusGetReady ; 
                        jsr BL_ScreenStatusRestore  ; 
                        
                        jsr TankInitAll             ; init
                        jsr TankInitScreenSprites   ; init playground/player sprites
                        
                        lda #$02                    ; 
                        sta HI_96d8                 ; 
                        
                        lda #$03                    ; 
                        sta HI_96e8                 ; 
                        
                        lda #$03                    ; 
                        jsr S_6609                  ; 
                        jsr S_942d                  ; 
                        
ChapTanksOnBeachLoop    jsr BL_TankScrollTerrain    ; scroll terrain forward
                        jsr TankPlayerCheckShoots   ; player: check start shooting
                        jsr TankPlayerCheckLimit    ; player: clear sprite
                        jsr BL_GetSprtSprtCollReg   ; sprite/sprite collision
                        jsr TankPlayerMovTank       ; player: move tank
                        jsr TankCheckPosCannon      ; enemy: cannon
                        jsr TankCheckPosTank        ; enemy: tank
                        jsr TankCheckPosMachGun     ; enemy: machine gun
                        jsr TankCheckPosTurret      ; enemy: turret
                        jsr TankEnemyMovTank        ; enemy: move tank
                        jsr TankEnemyShoot          ; enemy: shoots
                        jsr TankEnemyMovShot        ; enemy: move shot
                        jsr TankPlayerShoot         ; player: shoots
                        jsr TankPlayerMovShot       ; player: move shot
                        jsr TankPlayerHitCheck      ; player: hit check
                        jsr TankEnemyHitCheck       ; enemy: hit check
                        
                        jmp TankPlayerChkCollision  ; TankPlayerChkCollBack player: sprite/background collision
                                                    ; TankPlayerChkCollSprt player: sprite/Sprite     collision
                                                    ; --> jmp ChapTanksOnBeachBack
ChapTanksOnBeachBack    jsr TankEnemyClrHitScore    ; enemy: wipe out hit score 
                        jsr BL_ScreenStatusAmmoInc  ; 
                        jsr BL_ScreenStatusAmmoDec  ; 
                        jsr BL_ScreenStatusShowScore; 
                        jsr ScreenStatusTanksLeft   ; 
                        jsr LO_37e2                 ; 
                        jsr LO_381e                 ; 
                        
                        lda TabScrnTankBayScrollPos ; 
                        beq ChapTanksOnBeachX       ; next chapter
                        
                        jsr S_93ce                  ; display: clear unnecessary data from prev screen
                        jmp LO_2d41                 ; jsr LO_39df
                                                    ; jsr HI_863e
                                                    ; jsr HI_936c 
                                                    ; --> jmp XJ_818e
ChapTanksOnBeachBackL   jmp ChapTanksOnBeachLoop    ; 
                        
ChapTanksOnBeachX       jmp ChapStormTheHill        ; to Chapter: Storm the hill
; -------------------------------------------------------------------------------------------------------------- ;
J_8194                  jsr S_851a                  ; prepare Chapter: Tanks on the beach
; -------------------------------------------------------------------------------------------------------------- ;
; TankInitAll           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankInitAll             subroutine                  ; 
                        jsr BL_GameInit             ; 
                        
                        lda #$0a                    ; 
                        jsr TankGoResetSprites      ; 
                        
                        lda #$00                    ; 
                        sta T_973d                  ; 
                        sta T_973f                  ; 
                        
                        lda #$04                    ; 
                        jsr TankGoInitSpriteLevel   ; 
                        
TankInitAllX            rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankInitScreenSprites Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankInitScreenSprites   subroutine                  ; 
                        lda #VIC_Cols38             ; ####.###
                        and SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        jsr HI_81f7                 ; 
                        
                        lda #$00                    ; 
                        sta BGCOL0                  ; VIC($D021) Background Color 0
                        
                        ldx #<ScreenDataBayShore    ; 
                        ldy #>ScreenDataBayShore    ; 
                        jsr BL_ScreenGraphicCharSet ; 
                        
                        ldx #<ScreenDataStrandBridge; 
                        ldy #>ScreenDataStrandBridge; 
                        jsr BL_ScreenGraphicCharSet ; 
                        
                        ldx #$05                    ; 
                        jsr BL_SpriteDataCopyInit   ; 
                        
                        lda #BH_TabTankScrollAreaTabPtrStart ; screen_00
                        sta TabTankScrollAreaTabPtr ; to TabTankScrollAreaPtrLo/Hi table
                        
                        jsr BL_TankScreenShowStart  ; 
                        jsr TankSetBgColors         ; 
                        jsr ScreenStatusTank        ; 
                        jsr BL_ScreenStatusAmmoDec  ; 
                        jsr ScreenStatusTanksLeft   ; 
                        jsr S_8218                  ; 
                        
                        lda #BH_TabScrnTankBayScrollPosIni ; 
                        sta TabScrnTankBayScrollPos ; 
                        
                        lda #$ff                    ; 
                        sta HI_963e                 ; 
                        
TankInitScreenSpritesX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HI_81f7               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HI_81f7                 subroutine                  ; 
                        lda #$00                    ; 
                        ldx #$07                    ; 
B_81fb                  sta XT_47f8,x               ; 
                        dex                         ; 
                        bpl B_81fb                  ; 
                        
                        lda #$00                    ; screen B
                        sta TabTankActiveScreen     ; 
                        
                        ldx #$13                    ; 
B_8208                  jsr BL_TankObstIniScrnOutPtr; 
                        
                        ldy #$27                    ; 
                        lda #$ff                    ; 
B_820f                  sta (BHZ_fb),y              ; 
                        dey                         ; 
                        bpl B_820f                  ; 
                        
                        dex                         ; 
                        bpl B_8208                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8218                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8218                  subroutine                  ; 
                        ldx HI_960f                 ; 
                        dex                         ; 
B_821c                  lda #$41                    ; 
                        sta BH_SpritePointers,x     ; 
                        sta XT_4ff8,x               ; 
                        lda #$08                    ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda #$dc                    ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        dex                         ; 
                        bpl B_821c                  ; 
                        lda #$01                    ; 
                        sta SPMC0                   ; VIC($D025) Sprite Multicolor Register 0
                        lda #$00                    ; 
                        sta SPMC1                   ; VIC($D026) Sprite Multicolor Register 1
                        lda #$00                    ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        lda #$ff                    ; 
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$00                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        ldx HI_960f                 ; 
                        dex                         ; 
                        lda #$b8                    ; 
B_8256                  pha                         ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        pla                         ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$0a                    ; 
                        jsr S_9366                  ; 
                        dex                         ; 
                        bpl B_8256                  ; 
                        lda #$04                    ; 
                        sta HI_96f8                 ; 
                        jsr LO_21b2                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusTanksLeft Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusTanksLeft   subroutine                  ; 
                        ldx #$0a                    ; 
                        ldy HI_960f                 ; 
                        beq B_8286                  ; 
                        
B_8277                  lda #$71                    ; 
                        sta BH_Scrn_Status + $03c0,x; 
                        
                        lda #LT_BLUE                ; 
                        sta COLORAM + $03c0,x       ; 
                        
                        jsr S_955d                  ; 
                        bne B_8277                  ; 
                        
B_8286                  cpx #$25                    ; 
                        bne B_828b                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_828b                  lda #$20                    ; 
                        sta BH_Scrn_Status + $03c0,x; 
                        inx                         ; 
                        jmp B_8286                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerCheckLimit  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerCheckLimit    subroutine                  ; 
                        lda TabScrnTankBayScrollPos ; 
                        cmp #BH_TabScrnTankBayScrollPosGo ; 
                        beq .SwitchTanksOff         ; 
                        
                        rts                         ; 
                        
.SwitchTanksOff         lda #$01                    ; .......# - leave player only
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
TankPlayerCheckLimitX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerMovTank     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerMovTank       subroutine                  ; 
                        lda HI_96c0                 ; 
                        bne .Exit_1                 ; 
                        
                        inc HI_96c0                 ; 
                        
.ChkUp                  lda #CIA_Joy_Up             ; 
                        bit TabJoysticAction        ; 
                        beq .ChkDown                ; 
                        
                        jsr LO_3a98                 ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$68                    ; 
                        bcc .Exit_1                 ; 
                        
                        dec SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$42                    ; 
                        sta BH_SpritePointer00      ; 
                        sta XT_4ff8                 ; 
                        
.Exit_1                 rts                         ; 
                        
.ChkDown                lda #CIA_Joy_Do             ; 
                        bit TabJoysticAction        ; 
                        beq .TankSpriteDown         ; 
                        
                        jsr LO_3a98                 ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$b8                    ; 
                        bcs .Exit_1                 ; 
                        
                        inc SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
.TankSpriteUp           lda #$43                    ; 
                        sta BH_SpritePointer00      ; 
                        sta XT_4ff8                 ; 
                        
                        rts                         ; 
                        
.TankSpriteDown         lda #$41                    ; 
                        sta BH_SpritePointer00      ; 
                        sta XT_4ff8                 ; 
                        
TankPlayerMovTankX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankCheckPosCannon    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankCheckPosCannon      subroutine                  ; 
                        ldx #$00                    ; 
J_82f8                  lda TabPosEnemyCannon,x     ; enemy: cannon
                        bne B_82fe                  ; 
                        
                        rts                         ; 
                        
B_82fe                  cmp TabScrnTankBayScrollPos ; 
                        beq B_8308                  ; 
                        
                        inx                         ; 
                        inx                         ; 
                        jmp J_82f8                  ; 
                        
B_8308                  inx                         ; 
                        lda TabPosEnemyCannon,x     ; enemy: cannon
                        ldy #$09                    ; sprite color
                        ldx #$03                    ; sprite number
                        jsr S_836e                  ; 
                        
TankCheckPosCannonX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankCheckPosTank      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankCheckPosTank        subroutine                  ; 
                        ldx #$00                    ; 
J_8316                  lda TabPosEnemyTank,x       ; enemy: tank
                        bne B_831c                  ; 
                        
                        rts                         ; 
                        
B_831c                  cmp TabScrnTankBayScrollPos ; 
                        beq B_8326                  ; 
                        
                        inx                         ; 
                        inx                         ; 
                        jmp J_8316                  ; 
                        
B_8326                  inx                         ; 
                        lda TabPosEnemyTank,x       ; enemy: tank
                        ldy #$04                    ; sprite color
                        ldx #$04                    ; sprite number
                        jsr S_836e                  ; 
                        
TankCheckPosTankX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankCheckPosMachGun   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankCheckPosMachGun     subroutine                  ; 
                        ldx #$00                    ; 
J_8334                  lda TabPosEnemyGunner,x     ; enemy: machine gun
                        bne B_833a                  ; 
                        
                        rts                         ; 
                        
B_833a                  cmp TabScrnTankBayScrollPos ; 
                        beq B_8344                  ; 
                        
                        inx                         ; 
                        inx                         ; 
                        jmp J_8334                  ; 
                        
B_8344                  inx                         ; 
                        lda TabPosEnemyGunner,x     ; enemy: machine gun
                        ldy #$09                    ; sprite color
                        ldx #$05                    ; sprite number
                        jsr S_836e                  ; 
                        
TankCheckPosMachGunX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankCheckPosTurret    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankCheckPosTurret      subroutine                  ; 
                        ldx #$00                    ; 
J_8352                  lda TabPosEnemyTurret,x     ; enemy: turret
                        bne B_8358                  ; 
                        
                        rts                         ; 
                        
B_8358                  cmp TabScrnTankBayScrollPos ; 
                        beq B_8362                  ; 
                        
                        inx                         ; 
                        inx                         ; 
                        jmp J_8352                  ; 
                        
B_8362                  inx                         ; 
                        lda TabPosEnemyTurret,x     ; enemy: turret
                        ldy #$06                    ; sprite color
                        ldx #$06                    ; sprite number
                        jsr S_836e                  ; 
                        
TankCheckPosTurretX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_836e                Does    : 
;                       Expects : enemy sprite: ac=posy yr=color xr=number
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_836e                  subroutine                  ; 
                        jmp J_9502                  ; 
                        nop                         ; 
J_8372                  beq B_8379                  ; 
                        
                        dec TabBeachSpriteLevelTmp  ; 
                        pla                         ; 
                        
                        rts                         ; 
                        
B_8379                  tya                         ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        pla                         ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$00                    ; 
                        jsr S_93a8                  ; 
                        jsr LO_350f                 ; 
                        
                        eor #$ff                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$01                    ; 
                        sta HI_9718,x               ; 
                        
                        jsr LO_34f9                 ; 
                        
                        lda TabBeachSpriteLevel     ; 
                        sta TabBeachSpriteLevelTmp  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyMovTank      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyMovTank        subroutine                  ; 
                        lda T_971c                  ; 
                        bne B_83a9                  ; 
                        
                        rts                         ; 
                        
B_83a9                  lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
TankEnemyMovTankX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerCheckShoots Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerCheckShoots   subroutine                  ; 
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_83ce                  ; 
                        
B_83b7                  lda HI_96d0                 ; 
                        beq B_83bd                  ; 
                        
B_83bc                  rts                         ; 
                        
B_83bd                  inc HI_96d0                 ; 
                        
                        inc SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bne B_83bc                  ; 
                        
                        lda #$01                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        rts                         ; 
                        
B_83ce                  lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$20                    ; 
                        bcc B_83b7                  ; 
                        
TankPlayerCheckShootsX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyShoot        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyShoot          subroutine                  ; 
                        lda HI_973c                 ; 
                        beq B_83dc                  ; 
                        
                        rts                         ; 
                        
B_83dc                  lda T_973d                  ; 
                        beq B_83e5                  ; 
                        
                        tax                         ; 
                        jmp J_8400                  ; 
                        
B_83e5                  ldx #$03                    ; 
B_83e7                  lda HI_9718,x               ; 
                        beq B_83fa                  ; 
                        
                        jmp J_9416                  ; 
                        
J_83ef                  lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
HI_83f3                 equ * + $01                 ; 
                        cmp #$40                    ; 
                        bcc B_83fa                  ; 
                        
                        cmp #$d8                    ; 
                        bcc J_8400                  ; 
                        
B_83fa                  inx                         ; 
                        cpx #$07                    ; 
                        bne B_83e7                  ; 
                        
TankEnemyShootX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8400                  lda #$45                    ; 
                        sta BH_SpritePointer02      ; 
                        sta XT_4ffa                 ; 
                        
                        lda #$fb                    ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$fb                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$00                    ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$06                    ; 
                        sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        
                        lda #$01                    ; 
                        sta T_971a                  ; 
                        sta HI_973c                 ; 
                        
                        stx T_973d                  ; 
                        
                        ldx #$02                    ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$01                    ; 
                        sta T_96da                  ; 
                        
                        jsr LO_21c0                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyMovShot      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyMovShot        subroutine                  ; 
                        lda T_971a                  ; 
                        bne B_844e                  ; 
                        
B_844d                  rts                         ; 
                        
B_844e                  lda T_96b2                  ; 
                        bne B_844d                  ; 
                        
                        inc T_96b2                  ; 
                        lda #$04                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_8472                  ; 
                        
                        lda SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$58                    ; 
                        bcc B_8472                  ; 
                        
                        lda #$00                    ; 
                        sta T_971a                  ; 
                        sta HI_973c                 ; 
                        ldx #$02                    ; 
                        jsr LO_3503                 ; 
                        
TankEnemyMovShotX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8472                  lda TabSpriteScrollAddX02   ; 
                        clc                         ; 
                        adc T_973e                  ; 
                        sta TabSpriteScrollAddX02   ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerShoot       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerShoot         subroutine                  ; 
                        lda #CIA_Joy_Fi             ; 
                        bit TabJoysticAction        ; 
                        bne TankPlayerShootX        ; 
                        
B_8484                  rts                         ; 

TankPlayerShootX        jmp J_9439                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8488                  lda T_9719                  ; 
                        bne B_8484                  ; 
                        
                        lda #$44                    ; 
                        sta BH_SpritePointer01      ; 
                        sta XT_4ff9                 ; 
                        
                        lda #$fd                    ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$00                    ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$06                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        lda #$02                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        ldx #$01                    ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$01                    ; 
                        sta T_96d9                  ; 
                        sta T_9689                  ; 
                        sta T_9719                  ; 
                        jsr LO_1e4b                 ; 
                        jsr LO_3a53                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerMovShot     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerMovShot       subroutine                  ; 
                        lda T_9719                  ; 
                        bne B_84d6                  ; 
                        
B_84d5                  rts                         ; 
                        
B_84d6                  lda T_96b1                  ; 
                        bne B_84d5                  ; 
                        
                        inc T_96b1                  ; 
                        
                        lda #$02                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_84f7                  ; 
                        
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$30                    ; 
                        bcs B_84f7                  ; 
                        
                        lda #$00                    ; 
                        sta T_9719                  ; 
                        
                        ldx #$01                    ; 
                        jsr LO_3503                 ; 
                        
                        rts                         ; 
                        
B_84f7                  lda TabSpriteScrollAddX01   ; 
                        sec                         ; 
                        sbc T_975f                  ; 
                        sta TabSpriteScrollAddX01   ; 
                        
TankPlayerMovShotX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerHitCheck    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerHitCheck      subroutine                  ; 
                        lda T_971a                  ; 
                        bne B_8508                  ; 
                        
B_8507                  rts                         ; 
                        
B_8508                  lda #$05                    ; 
                        jsr S_9427                  ; 
                        bne B_8507                  ; 
                        
                        ldx #$02                    ; 
                        jsr LO_3503                 ; 
J_8514                  jsr LO_1e6c                 ; 
TankPlayerHitCheckX     jsr S_853f                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_851a                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_851a                  subroutine                  ; 
                        dec HI_960f                 ; 
                        beq B_8532                  ; 
                        
                        jsr S_8678                  ; 
                        
                        inc T_9741                  ; 
                        jsr LO_2bdf                 ; 
                        
                        lda #$01                    ; 
                        sta HI_96d8                 ; 
                        
                        pla                         ; 
                        pla                         ; 
                        jmp ChapTanksOnBeach        ; to Chapter: Tanks on the beach
; -------------------------------------------------------------------------------------------------------------- ;
B_8532                  jsr LO_39b6                 ; 
                        
                        lda #$00                    ; 
J_8537                  jmp LO_2ccb                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_853a                 pla                         ; 
                        pla                         ; 
                        
                        pla                         ; 
                        pla                         ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_853f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_853f                  subroutine                  ; 
                        lda #$40                    ; 
                        sta BH_SpritePointer00      ; 
                        sta XT_4ff8                 ; 
                        lda #$fe                    ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$02                    ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        lda #$06                    ; 
                        sta HI_96d8                 ; 
                        sta HI_9688                 ; 
                        ldx #$09                    ; 
B_855e                  lda HI_96b0                 ; 
                        bne B_855e                  ; 
                        inc HI_96b0                 ; 
                        dec SP0COL                  ; VIC($D027) Color Sprite 0
                        bpl B_855e                  ; 
                        dex                         ; 
                        bne B_855e                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyHitCheck     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyHitCheck       subroutine                  ; 
                        lda T_9719                  ; 
                        bne B_8575                  ; 
                        
B_8574                  rts                         ; 
                        
B_8575                  lda #$02                    ; 
                        bit TabSprtSprtCollReg      ; 
                        beq B_8574                  ; 
                        
                        ldx #$03                    ; 
B_857e                  jsr LO_350f                 ; 
                        
                        bit TabSprtSprtCollReg      ; 
                        bne B_858c                  ; 
                        
                        inx                         ; 
                        cpx #$07                    ; 
                        bne B_857e                  ; 
                        
                        rts                         ; 
                        
B_858c                  dec T_9719                  ; 
                        jsr LO_1e6c                 ; 
                        
                        lda #$fd                    ; ######.#
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        cpx T_973d                  ; 
                        bne B_85a4                  ; 
                        
                        lda #$00                    ; 
                        sta T_973d                  ; 
B_85a4                  jsr LO_350f                 ; 
                        
                        eor #$ff                    ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$00                    ; 
                        jsr S_940f                  ; 
                        
                        lda #$3c                    ; 
                        sta T_96ea                  ; 
                        sta HI_969a                 ; 
                        lda #$01                    ; 
                        sta HI_96c2                 ; 
                        stx T_973f                  ; 
                        cpx #$03                    ; 
                        bne B_85d0                  ; 
                        
                        jsr LO_377e                 ; 
                        
                        lda #$4d                    ; 
                        jmp J_85ed                  ; 
                        
B_85d0                  cpx #$04                    ; 
                        bne B_85dc                  ; 
                        
                        jsr LO_3781                 ; 
                        
                        lda #$4e                    ; 
                        jmp J_85ed                  ; 
                        
B_85dc                  cpx #$05                    ; 
                        bne B_85e8                  ; 
                        
                        jsr LO_3778                 ; 
                        
                        lda #$4b                    ; 
                        jmp J_85ed                  ; 
                        
B_85e8                  jsr LO_377b                 ; 
                        
                        lda #$4c                    ; 
J_85ed                  sta BH_SpritePointers,x     ; 
                        sta XT_4ff8,x               ; 
                        
TankEnemyHitCheckX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyClrHitScore  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyClrHitScore    subroutine                  ; 
                        lda T_973f                  ; 
                        bne B_85fa                  ; 
                        
B_85f9                  rts                         ; 
B_85fa                  lda HI_96c2                 ; 
                        bne B_85f9                  ; 
                        
                        ldx T_973f                  ; 
                        lda #$00                    ; 
                        sta T_973f                  ; 
                        
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        
                        jsr LO_3503                 ; 
                        
TankEnemyClrHitScoreX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerChkCollBack Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerChkCollBack   subroutine                  ; 
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        and #$01                    ; 
                        bne TankPlayerChkCollBackX  ; 
                        
                        rts                         ; 
                        
TankPlayerChkCollBackX  jmp J_8514                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerChkCollSprt Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerChkCollSprt   subroutine                  ; 
                        lda #$01                    ; 
                        bit TabSprtSprtCollReg      ; 
                        bne B_8621                  ; 
                        
B_8620                  rts                         ; 
                        
B_8621                  ldx #$03                    ; 
B_8623                  jsr LO_350f                 ; 
                        
                        bit TabSprtSprtCollReg      ; 
                        bne TankPlayerChkCollSprtX  ; 
                        
                        inx                         ; 
                        cpx #$07                    ; 
                        bne B_8623                  ; 
                        
                        rts                         ; 
                        
TankPlayerChkCollSprtX  jmp J_863b                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        beq B_8620                  ; 
                        
                        cpx T_973f                  ; 
                        beq B_8620                  ; 
                        
J_863b                  jmp J_8514                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_863e                 lda TabGameMode             ; 
                        bne B_8644                  ; 
                        
                        rts                         ; 
                        
B_8644                  lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$25                    ; 
                        bne B_8653                  ; 
                        
                        jsr BL_InitTOD              ; 
                        
                        pla                         ; 
                        pla                         ; 
                        jmp ChapStormTheHill        ; to Chapter: Storm the hill
                        
B_8653                  cmp #$10                    ; 
                        bne B_865f                  ; 
                        
                        lda #CIA_Joy_Do             ; 
                        sta TabJoysticAction        ; 
                        jmp J_8668                  ; 
                        
B_865f                  cmp #$18                    ; 
                        bne J_8668                  ; 
                        
                        lda #CIA_Joy_Up             ; 
                        sta TabJoysticAction        ; 
                        
J_8668                  lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$02                    ; 
                        bcc B_8677                  ; 
                        
                        lda #CIA_Joy_Fi             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
B_8677                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8678                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8678                  subroutine                  ; 
                        lda TabGameMode             ; 
                        bne B_867e                  ; 
                        
                        rts                         ; 
                        
B_867e                  jsr BL_InitTOD              ; 
                        
                        pla                         ; 
                        pla                         ; 
                        
                        pla                         ; 
                        pla                         ; 
                        jmp ChapStormTheHill        ; to Chapter: Storm the hill
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusTank      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusTank        subroutine                  ; 
HI_8688                 equ *                       ; 
                        lda #CYAN                   ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$18                    ; 
                        ldx #<TabTextStatus104mm    ; 
                        jsr BL_ScreenStatusTextOutRow2 ; xr=input text offset  yr=output text offset
                        
                        lda #$ff                    ; flag: blank
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$16                    ; 
                        ldx #<TabTextStatusCopyright + $01 ; 
                        jsr BL_ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        ldy #$16                    ; 
                        ldx #<TabTextStatusEndOfTxt ; 
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
                        lda #WHITE                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$04                    ; 
                        ldx #<TabTextStatusTanks    ; 
                        jsr BL_ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
ScreenStatusTankX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankSetBgColors       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankSetBgColors         subroutine                  ; 
                        lda #$02                    ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #GREEN                  ; 
                        sta BGCOL2                  ; VIC($D023) Background Color 2
                        lda #RED                    ; 
                        sta BGCOL1                  ; VIC($D022) Background Color 1
                        
                        lda #LT_GREY                ; 
                        sta TabBackGroundColor      ; 
                        
TankSetBgColorsX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ChapStormTheHill      Does    : Chapter: Storm the hill
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ChapStormTheHill        jsr S_872d                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda TabVicMemControlSetA    ; 
                        sta TabVicMemControl        ; 
                        
                        lda #$01                    ; screen A
                        sta TabTankActiveScreen     ; 
                        
                        ldx #<ScreenDataHill        ; 
                        ldy #>ScreenDataHill        ; 
                        jsr BL_ScreenGraphicInit    ; Init game screen data - Hill
                        
                        ldx #$06                    ; 
                        jsr BL_SpriteDataCopyInit   ; 
                        jsr HillCannonAutoPaint     ; paint hill cannon
                        jsr S_9463                  ; 
                        jsr S_877b                  ; set next hill target
                        
.StormHillLoop          jsr BL_GetSprtSprtCollReg   ; sprite/sprite collision
                        jsr BL_GetSprtBackCollReg   ; sprite/foregr collision
                        jsr HillCannonAutoTarget    ; target hill cannon to player
                        jsr HillCannonAutoFire      ; fire   hill cannon
                        jsr CannonPlayerMove        ; move player cannon
                        jsr HillCannonPlayerFire    ; fire player cannon
                        jsr S_889c                  ; 
                        jsr S_88f2                  ; check target hits
                        jsr S_8934                  ; 
                        jsr LO_3a5d                 ; 
                        jsr BL_ScreenStatusShowScore; 
                        jsr S_7f28                  ; 
                        jsr BL_ScreenStatusAmmoDec  ; 
                        jsr S_947b                  ; 
                        jsr LO_37e2                 ; 
                        jsr LO_381e                 ; 
                        jsr LO_39df                 ; 
                        jsr S_8bb1                  ; demo
                        
ChapStormTheHillX       jmp .StormHillLoop          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_872d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_872d                  subroutine                  ; 
                        jsr BL_GameInit             ; 
                        
                        lda #$00                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #$41                    ; 
                        jsr S_9455                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonAutoPaint   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonAutoPaint     subroutine                  ; 
                        lda #$51                    ; 
                        sta BH_SpritePointer03      ; 
                        
                        lda #$90                    ; 
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$42                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #$08                    ; 
                        ora XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #$00                    ; 
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        
                        lda #$10                    ; 
                        jsr S_94bd                  ; 
                        
                        sta HI_968b                 ; 
                        
                        lda #$00                    ; 
                        sta HI_9720                 ; 
                        
                        lda #$01                    ; 
                        sta T_971b                  ; 
                        sta HI_96b3                 ; 
                        
                        ldx #$03                    ; 
                        jsr LO_21e1                 ; 
                        
HillCannonAutoPaintX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_877b                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_877b                  subroutine                  ; 
                        ldx HillTargetsToHit        ; 
                        dex                         ; 
                        
                        lda T_879b,x                ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda T_87a5,x                ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
                        lda #$01                    ; 
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        
                        lda #$67                    ; 
                        sta BH_SpritePointer04      ; 
                        
                        ldx #$04                    ; 
                        jsr LO_34f9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_879b                  dc.b $b9 ; 
                        dc.b $81 ; 
                        dc.b $a9 ; 
                        dc.b $d7 ; 
                        dc.b $79 ; 
                        dc.b $d9 ; 
                        dc.b $c7 ; 
                        dc.b $91 ; 
                        dc.b $c7 ; 
                        dc.b $a1 ; 
                        
T_87a5                  dc.b $6a ; 
                        dc.b $82 ; 
                        dc.b $5a ; 
                        dc.b $65 ; 
                        dc.b $75 ; 
                        dc.b $85 ; 
                        dc.b $5d ; 
                        dc.b $65 ; 
                        dc.b $7a ; 
                        dc.b $7d ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonAutoTarget  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonAutoTarget    subroutine                  ; 
                        lda $971b                   ; 
                        bne B_87b5                  ; 
                        
B_87b4                  rts                         ; 
                        
B_87b5                  lda HI_96b3                 ; 
                        bne B_87b4                  ; 
                        
                        jsr LO_21e8                 ; 
                        
                        inc BH_SpritePointer03      ; 
                        
                        lda BH_SpritePointer03      ; 
                        cmp #$5e                    ; 
                        bne B_87d6                  ; 
                        
                        lda HI_9720                 ; 
                        bne B_87b4                  ; 
                        
                        inc HI_9720                 ; 
                        dec BH_SpritePointer03      ; 
                        jsr LO_1f3e                 ; 
                        
HillCannonAutoTargetX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_87d6                  cmp #$67                    ; 
                        bne B_87b4                  ; 
                        dec BH_SpritePointer03      ; 
                        lda #$b0                    ; 
                        sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$43                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        lda #$00                    ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        lda #$00                    ; 
                        sta T_971b                  ; 
                        lda #$01                    ; 
                        sta T_971a                  ; 
                        sta T_96b2                  ; 
                        lda #$02                    ; 
                        sta T_96da                  ; 
                        sta HI_968a                 ; 
                        jsr LO_1ee4                 ; 
                        lda #$85                    ; 
                        sta BH_SpritePointer02      ; 
                        ldx #$02                    ; 
                        jsr LO_34f9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonAutoFire    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonAutoFire      subroutine                  ; 
                        lda T_971a                  ; 
                        bne B_8815                  ; 
                        
B_8814                  rts                         ; 
                        
B_8815                  lda T_96b2                  ; 
                        bne B_8814                  ; 
                        
                        inc T_96b2                  ; 
                        
                        lda BH_SpritePointer02      ; 
                        cmp #$8d                    ; 
                        beq B_8828                  ; 
                        
                        inc BH_SpritePointer02      ; 
                        
                        rts                         ; 
                        
B_8828                  lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$00                    ; 
                        sta BGCOL0                  ; VIC($D021) Background Color 0
                        
                        jsr HI_81f7                 ; 
                        
                        lda #$02                    ; 
                        sta HI_9617                 ; 
                        
                        jsr S_9513                  ; 
                        
                        pla                         ; 
                        pla                         ; 
HillCannonAutoFireX     jmp J_8194                  ; to prepare Chapter: Tanks on the beach/init
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonPlayerFire  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonPlayerFire    subroutine                  ; 
                        lda #CIA_Joy_Fi             ; 
                        bit TabJoysticAction        ; 
                        bne B_884a                  ; 
                        
B_8849                  rts                         ; 
                        
B_884a                  jsr BL_ClearDirInJoyAction  ; 
                        
                        lda T_9719                  ; 
                        bne B_8849                  ; 
                        
                        lda #$95                    ; 
                        sta BH_SpritePointer01      ; 
                        
                        lda #$00                    ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc HI_961b                 ; 
                        jsr S_94b1                  ; 
                        lda #$01                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        asl a                       ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        inc T_9719                  ; 
                        ldx #$01                    ; 
                        jsr LO_34f9                 ; 
                        
                        jsr LO_2256                 ; 
                        jsr LO_3a53                 ; 
                        lda #$01                    ; 
                        sta T_96d9                  ; 
                        sta T_9689                  ; 
                        lda #$01                    ; 
                        sta T_96b1                  ; 
                        lda #$00                    ; 
                        sta GR_bed0                 ; 
                        
HillCannonPlayerFireX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_889c                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_889c                  subroutine                  ; 
                        lda T_9719                  ; 
                        bne B_88a2                  ; 
B_88a1                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_88a2                  lda T_96b1                  ; 
                        bne B_88a1                  ; 
                        inc T_96b1                  ; 
                        inc GR_bed0                 ; 
                        lda GR_bed0                 ; 
                        cmp #$2e                    ; 
                        bne B_88bd                  ; 
                        ldx #$01                    ; 
                        jsr LO_3503                 ; 
                        dec T_9719                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_88bd                  lda BH_SpritePointer01      ; 
                        cmp #$8e                    ; 
                        beq B_88d5                  ; 
                        lda GR_bed0                 ; 
                        lsr a                       ; 
                        jsr S_946f                  ; 
                        lda #$95                    ; 
                        nop                         ; 
                        sec                         ; 
                        sbc HI_9740                 ; 
                        sta BH_SpritePointer01      ; 
                        
B_88d5                  lda HI_9620                 ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        sta HI_9729                 ; 
                        lda HI_9620                 ; 
                        sec                         ; 
                        sbc HI_9729                 ; 
                        sta HI_9620                 ; 
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc HI_9729                 ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_88f2                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_88f2                  subroutine                  ; 
                        lda T_9719                  ; 
                        bne B_88f8                  ; 
B_88f7                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_88f8                  lda #$02                    ; 
                        bit TabSprtSprtCollReg      ; 
                        beq B_88f7                  ; 
                        
                        lda #$10                    ; 
                        bit TabSprtSprtCollReg      ; 
                        beq B_88f7                  ; 
                        
                        lda GR_bed0                 ; 
                        cmp #$19                    ; 
                        bcc B_88f7                  ; 
                        
                        ldx #$01                    ; 
                        jsr LO_3503                 ; 
                        
                        dec T_9719                  ; 
                        jsr LO_3784                 ; 
                        
                        dec HillTargetsToHit        ; 
                        beq B_8924                  ; 
                        
                        jsr LO_1eb4                 ; 
                        jsr S_877b                  ; set next hill target
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8924                  jsr S_6684                  ; 
                        jsr S_8b52                  ; 
                        
                        lda #$01                    ; 
                        jmp J_8537                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        pla                         ; 
                        pla                         ; 
                        
                        pla                         ; 
                        pla                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8934                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8934                  subroutine                  ; 
                        lda T_9719                  ; 
                        bne B_893a                  ; 
B_8939                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_893a                  lda GR_bed0                 ; 
                        cmp #$1e                    ; 
                        bcc B_8939                  ; 
                        lda #$68                    ; 
                        sta BH_SpritePointer07      ; 
                        lda #$08                    ; 
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$7f                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$01                    ; 
                        beq B_896b                  ; 
                        lda #$80                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
B_896b                  jsr LO_1eb4                 ; 
                        jsr S_9482                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_8972                  dc.b $b7 ; 
                        stx BHZ_60,y                ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8975                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8975                  subroutine                  ; 
                        lda #$00                    ; 
                        jsr S_94c3                  ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        jsr S_8c17                  ; 
                        lda #$42                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        lda #$4a                    ; 
                        sta SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        sta SP6Y                    ; VIC($D00D) Sprite 6 Y-Pos (Bits 0-7)
                        lda #$a8                    ; 
                        sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$b0                    ; 
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$b8                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        ldx #$02                    ; 
                        lda #$09                    ; 
B_89b2                  sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        inx                         ; 
                        cpx #$07                    ; 
                        bne B_89b2                  ; 
                        lda #$01                    ; 
                        sta SPMC0                   ; VIC($D025) Sprite Multicolor Register 0
                        lda #$00                    ; 
                        sta SPMC1                   ; VIC($D026) Sprite Multicolor Register 1
                        lda #$08                    ; 
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        lda #$7c                    ; 
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$30                    ; 
                        sta T_970b                  ; 
                        lda #$28                    ; 
                        sta T_970a                  ; 
                        sta HI_970c                 ; 
                        lda #$14                    ; 
                        sta HI_9704                 ; 
                        ora #$80                    ; 
                        sta T_9702                  ; 
                        lda #$3b                    ; 
                        sta T_9706                  ; 
                        ora #$80                    ; 
                        sta HI_9705                  ; 
                        lda #$00                    ; 
                        sta T_970d                  ; 
                        sta T_970e                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$45                    ; 
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$04                    ; 
                        sta T_96d9                  ; 
                        sta T_9689                  ; 
                        lda #$3c                    ; 
                        sta T_968f                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$02                    ; 
                        sta HI_96f0                 ; 
                        sta T_96a0                  ; 
                        lda #$01                    ; 
                        sta HI_96c8                 ; 
                        lda #$01                    ; 
                        sta T_96b1                  ; 
                        sta T_96b7                  ; 
                        lda #$fd                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        jsr S_8b34                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jsr LO_1f09                 ; 
                        lda #$7c                    ; 
                        jsr HI_8d82                 ; 
                        
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
J_8a51                  jsr S_8a63                  ; 
                        jsr S_8a9f                  ; 
                        jsr S_8ace                  ; 
                        jsr S_8b1b                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jmp J_8a51                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8a63                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8a63                  subroutine                  ; 
                        lda HI_96c8                 ; 
                        beq B_8a69                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8a69                  inc HI_96c8                 ; 
                        ldx #$02                    ; 
B_8a6e                  lda HI_9708,x               ; 
                        bmi B_8a86                  ; 
                        beq B_8a7e                  ; 
                        dec HI_9708,x               ; 
J_8a78                  inx                         ; 
                        cpx #$07                    ; 
                        bne B_8a6e                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8a7e                  ora #$80                    ; 
                        sta HI_9708,x               ; 
                        jmp J_8a78                  ; 
B_8a86                  cmp #$bb                    ; 
                        beq J_8a78                  ; 
                        inc HI_9708,x               ; 
                        jmp J_8a78                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8a9f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8a9f                  subroutine                  ; 
                        lda T_96b1                  ; 
                        beq B_8aa5                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8aa5                  inc T_96b1                  ; 
                        ldx #$02                    ; 
B_8aaa                  lda HI_9798,x               ; 
                        beq B_8ac8                  ; 
                        lda BH_SpritePointer03      ; 
                        cmp #$71                    ; 
                        beq B_8abc                  ; 
                        inc BH_SpritePointers,x     ; 
                        jmp B_8ac8                  ; 
B_8abc                  txa                         ; 
                        sec                         ; 
                        sbc #$02                    ; 
                        asl a                       ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #$6a                    ; 
                        sta BH_SpritePointers,x     ; 
B_8ac8                  inx                         ; 
                        cpx #$07                    ; 
                        bne B_8aaa                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8ace                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8ace                  subroutine                  ; 
                        lda #$00                    ; 
                        sta TabTankObstOffNext      ; 
                        ldx #$02                    ; 
B_8ad5                  jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp T_8b13,x                ; 
                        bcc B_8ae8                  ; 
                        lda #$00                    ; 
                        sta HI_9798,x               ; 
                        jmp J_8aeb                  ; 
B_8ae8                  inc TabTankObstOffNext      ; 
J_8aeb                  inx                         ; 
                        cpx #$07                    ; 
                        bne B_8ad5                  ; 
                        lda TabTankObstOffNext      ; 
                        bne B_8af7                  ; 
                        pla                         ; 
                        pla                         ; 
B_8af7                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_8b13                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $98 ; 
                        dc.b $a2 ; 
                        dc.b $9c ; 
                        dc.b $88 ; 
                        dc.b $8c ; 
                        dc.b $60 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8b1b                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8b1b                  subroutine                  ; 
                        lda T_96b7                  ; 
                        beq B_8b21                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8b21                  lda #$00                    ; 
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8b34                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8b34                  subroutine                  ; 
                        lda #$5c                    ; 
                        sta XT_488b                 ; 
                        sta XT_488c                 ; 
                        sta XT_488d                 ; 
                        sta XT_488e                 ; 
                        sta XT_48b2                 ; 
                        sta XT_48b3                 ; 
                        sta XT_48b4                 ; 
                        sta XT_48b5                 ; 
                        jsr S_94cd                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8b52                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8b52                  subroutine                  ; 
                        ldx #$02                    ; 
B_8b54                  lda HI_9670,x               ; 
                        beq B_8b5a                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8b5a                  inx                         ; 
                        cpx #$07                    ; 
                        bne B_8b54                  ; 
                        lda #$7e                    ; 
                        sta BH_SpritePointer01      ; 
                        
                        lda #$0a                    ; 
                        sta T_96d9                  ; 
                        sta T_9689                  ; 
                        lda #$01                    ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        lda #$44                    ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        lda #$b0                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        ldx #$01                    ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$01                    ; 
                        sta T_96b1                  ; 
                        jsr LO_33ea                 ; ResetTOD
B_8b88                  jsr SimpleRTS               ; 
                        lda T_96b1                  ; 
                        bne B_8b88                  ; 
                        inc T_96b1                  ; 
                        lda BH_SpritePointer01      ; 
                        cmp #$83                    ; 
                        beq B_8ba0                  ; 
                        inc BH_SpritePointer01      ; 
                        jmp J_8ba5                  ; 
B_8ba0                  lda #$7e                    ; 
                        sta BH_SpritePointer01      ; 
                        
J_8ba5                  lda TODSEC                  ; CIA1($DC09) Time of Day Clock Seconds
                        cmp #$10                    ; 
                        bcc B_8b88                  ; 
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SimpleRTS             Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SimpleRTS               subroutine                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8bb1                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8bb1                  subroutine                  ; 
                        lda TabGameMode             ; 
                        bne B_8bb7                  ; 
                        
                        rts                         ; 
                        
B_8bb7                  lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$10                    ; 
                        bne B_8bcd                  ; 
                        
                        jsr BL_InitTOD              ; 
                        
                        pla                         ; 
                        pla                         ; 
                        
                        pla                         ; 
                        pla                         ; 
                        
                        nop                         ; 
                        nop                         ; 
                        
                        lda #$02                    ; 
                        sta HI_9608                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8bcd                  lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_8bdc                  ; 
                        
B_8bd4                  lda #CIA_Joy_Le             ; 
                        sta TabJoysticAction        ; 
                        
                        jmp J_8beb                  ; 
                        
B_8bdc                  lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq J_8beb                  ; 
                        bcs B_8bd4                  ; 
                        
                        lda #CIA_Joy_Ri             ; 
                        sta TabJoysticAction        ; 
J_8beb                  jsr LO_2d4d                 ; 
                        
                        cmp SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        beq B_8bfd                  ; 
                        bcs B_8c06                  ; 
                        
                        lda #CIA_Joy_Up             ; 
B_8bf7                  ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
B_8bfd                  lda #CIA_Joy_Fi             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
                        
B_8c06                  lda #$02                    ; 
                        bne B_8bf7                  ; 
                        
                        lda #WHITE                  ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$18                    ; 
                        ldx #<TabTextStatusDegElev  ; 
                        jsr BL_ScreenStatusTextOutRow4 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8c17                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8c17                  subroutine                  ; 
                        ldx #$02                    ; 
B_8c19                  txa                         ; 
                        sec                         ; 
                        sbc #$02                    ; 
                        asl a                       ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #$6a                    ; 
                        sta BH_SpritePointers,x     ; 
                        inx                         ; 
                        cpx #$07                    ; 
                        bne B_8c19                  ; 
                        lda #$69                    ; 
                        sta BH_SpritePointer07      ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMoveMyFleetSetLeft Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetSetLeft   subroutine                  ; 
                        lda HI_9670                 ; 
                        bmi MapMoveMyFleetSetLeftX  ; 
                        
                        dec HI_9670                 ; 
                        
MapMoveMyFleetSetLeftX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8c39                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetSetRight  subroutine                  ; 
                        lda HI_9670                 ; 
                        cmp #$01                    ; 
                        beq MapMoveMyFleetSetRightX ; 
                        
                        inc HI_9670                 ; 
                        
MapMoveMyFleetSetRightX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMoveMyFleetSetUp   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetSetUp     subroutine                  ; 
                        lda HI_9678                 ; 
                        cmp #$01                    ; 
                        beq MapMoveMyFleetSetUpX    ; 
                        
                        inc HI_9678                 ; 
                        
MapMoveMyFleetSetUpX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        nop                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMoveMyFleetSetDown Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetSetDown   subroutine                  ; 
                        lda HI_9678                 ; 
                        bmi MapMoveMyFleetSetDownX  ; 
                        
                        dec HI_9678                 ; 
                        
MapMoveMyFleetSetDownX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
MapMoveMyFleetChkLeft   subroutine                  ; 
                        lda HI_96c0                 ; 
                        bne MapMoveMyFleetChkLeftX  ; 
                        
                        inc HI_96c0                 ; 
                        
.ChkLeft                lda #CIA_Joy_Le             ; .....#..
                        bit TabJoysticAction        ; 
                        
                        jmp MapMoveMyFleetJoyLeft   ; 
                        
MapMoveMyFleetChkLeftX  jmp MapMoveMyFleetJoyReset  ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8c6c                 sta TabVicMemControl        ; SetA
                        
                        lda #BLACK                  ; 
                        sta TabBackGroundColor      ; 
                        
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SpriteOffC64Reset     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SpriteOffC64Reset       subroutine                  ; 
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        jsr BL_C64Reset             ; 
                        
SpriteOffC64ResetX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8c81                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8c81                  subroutine                  ; 
                        lda BGCOL1                  ; VIC($D022) Background Color 1
                        and #$0f                    ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ClearJoyActionLeRi    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ClearJoyActionLeRi      subroutine                  ; 
                        lda #[CIA_Joy_Le + CIA_Joy_Ri] ; ....##..
                        jsr BL_ClearDirInJoyAction  ; 
                        
                        lda HI_975e                 ; 
                        
ClearJoyActionLeRiX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8c90                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8c90                  subroutine                  ; 
                        sta T_9614                  ; 
                        jsr BL_GetSprtSprtCollReg   ; sprite/sprite collision
                        
                        lda #$00                    ; 
                        jsr S_8cec                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8c9c                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8c9c                  subroutine                  ; 
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$50                    ; 
                        bcs B_8ca5                  ; 
                        lda #$a1                    ; 
B_8ca5                  sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8ca9                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8ca9                  subroutine                  ; 
                        stx HI_9612                 ; 
                        cpx TabPlayerLives          ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8cb0                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8cb0                  subroutine                  ; 
                        ldx #$04                    ; 
                        jsr HI_6d3e                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8cb6                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8cb6                  subroutine                  ; 
                        lda BGCOL0                  ; VIC($D021) Background Color 0
                        and #$0f                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8cbc                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8cbc                  subroutine                  ; 
                        ldx #$00                    ; 
                        jsr LO_3503                 ; 
                        lda #$09                    ; 
                        sta HI_9618                 ; 
                        jsr LO_3408                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8cca                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8cca                  subroutine                  ; 
                        lda #$00                    ; 
                        sta HI_9798                 ; 
                        jsr LO_2200                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8cd3                 adc HI_97b8                 ; 
                        cmp #$ba                    ; 
                        bcc B_8cdc                  ; 
                        lda #$00                    ; 
B_8cdc                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8cdd                 sbc HI_97b8                 ; 
                        bcs B_8ce4                  ; 
                        lda #$b8                    ; 
B_8ce4                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8ce5                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8ce5                  subroutine                  ; 
                        lda TabSprtSprtCollReg      ; 
                        ora SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8cec                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8cec                  subroutine                  ; 
                        sta TabSprtSprtCollReg      ; 
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        pla                         ; 
                        pla                         ; 
                        jmp HI_6a0a                 ; 
J_8cf8                  lda TabPlayerLives          ; 
                        cmp HI_9612                 ; 
                        beq B_8d06                  ; 
                        jsr S_7026                  ; 
                        jmp J_6f5b                  ; 
B_8d06                  jmp J_6f8e                  ; 
                        pla                         ; 
                        pla                         ; 
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        ldx #$07                    ; 
B_8d12                  sta HI_9798,x               ; 
                        dex                         ; 
                        bpl B_8d12                  ; 
                        jmp HI_6a0a                 ; 
J_8d1b                  lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_8d2d                  ; 
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$a2                    ; 
                        beq B_8d2a                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8d2a                  jmp J_6a44                  ; 
B_8d2d                  lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        jmp J_8d63                  ; 
J_8d33                  jsr S_8d39                  ; 
                        jmp B_6a69                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8d39                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8d39                  subroutine                  ; 
                        lda #$52                    ; 
                        sta XT_49d2                 ; 
                        sta XT_49fc                 ; 
                        sta XT_4a26                 ; 
                        lda #$53                    ; 
                        sta XT_49d3                 ; 
                        sta XT_49fd                 ; 
                        sta XT_4a27                 ; 
                        jsr SimpleRTS               ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8d53                  lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_8d60                  ; 
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        jmp J_6a85                  ; 
B_8d60                  jmp B_6a98                  ; 
J_8d63                  ldx SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cpx #$e8                    ; 
                        bcc B_8d6d                  ; 
                        sec                         ; 
                        sbc #$10                    ; 
B_8d6d                  jmp J_6a40                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8d70                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8d70                  subroutine                  ; 
                        lda #$00                    ; 
                        sta HI_9670                 ; 
                        sta HI_9678                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr BL_GameInit             ; 
                        
                        lda #$01                    ; 
                        sta HI_9656                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HI_8d82               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8d82                 subroutine                  ; 
                        ldy #$07                    ; 
B_8d84                  asl a                       ; 
                        pha                         ; 
                        
                        lda #$00                    ; 
                        bcc B_8d8c                  ; 
                        
                        lda #$01                    ; 
B_8d8c                  sta HI_9798,y               ; 
                        
                        pla                         ; 
                        dey                         ; 
                        bpl B_8d84                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8d94                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8d94                  subroutine                  ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$00                    ; 
                        jsr HI_8d82                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8d9d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8d9d                  subroutine                  ; 
                        sta HI_96e8                 ; 
                        
                        ldx #$00                    ; 
                        jsr LO_34f9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8da6                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8da6                  subroutine                  ; 
                        ldx #$27                    ; 
B_8da8                  lda #$4f                    ; 
                        sta XT_4af8,x               ; 
                        
                        lda #BLACK                  ; 
                        sta COLORAM + $02f8,x       ; 
                        
                        dex                         ; 
                        bpl B_8da8                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr S_8da6                  ; 
                        
                        lda #$14                    ; 
                        sta HI_9602                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8dbf                  lda BH_SpritePointer00      ; 
                        clc                         ; 
                        adc #$02                    ; 
                        pha                         ; 
                        sbc #$0f                    ; 
                        cmp T_961a                  ; 
                        pla                         ; 
                        bcs B_8dd4                  ; 
                        sta BH_SpritePointer00      ; 
                        jmp J_724b                  ; 
B_8dd4                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8dd5                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8dd5                  subroutine                  ; 
                        jsr LO_350f                 ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8ddf                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8ddf                  subroutine                  ; 
                        jsr LO_350f                 ; 
                        eor #$ff                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8deb                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8deb                  subroutine                  ; 
                        lsr a                       ; 
                        sta HI_9729                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8df0                 ldx #$00                    ; 
                        ldy HI_972a                 ; 
                        dey                         ; 
                        bmi B_8dfb                  ; 
                        
                        jmp LO_3a7e                 ; 
                        
B_8dfb                  jmp LO_3a8d                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8dfe                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8dfe                  subroutine                  ; 
                        lda #$08                    ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8e04                 sta TabVicScrollSoftPosX    ; 
                        sta HI_9718,x               ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8e0b                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8e0b                  subroutine                  ; 
                        jsr S_8da6                  ; 
                        
                        lda #$00                    ; 
                        sta HI_971d                 ; 
                        lda #$05                    ; 
                        sta HI_97b9                 ; 
                        lda #$06                    ; 
                        sta HI_97ba                 ; 
                        lda #$00                    ; 
                        jsr LO_25ee                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        lda SPMC                    ; VIC($D01C) Sprite Multicolor
                        and #$0f                    ; 
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$04                    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8e30                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8e30                  subroutine                  ; 
                        jsr LO_2600                 ; 
                        jsr LO_28f8                 ; 
                        jsr LO_2a11                 ; 
                        jsr LO_2a97                 ; 
                        jsr LO_2ad4                 ; 
                        jsr LO_2b49                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8e43                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8e43                  subroutine                  ; 
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        lda #$ff                    ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        cmp #$01                    ; 
                        beq B_8e4e                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8e4e                  lda HI_9720,x               ; 
                        jmp LO_260d                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8e54                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8e54                  subroutine                  ; 
                        sta T_961a                  ; 
                        lda #$ff                    ; 
                        sta HI_971d                 ; 
                        sta T_971e                  ; 
                        sta T_971f                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8e63                 cmp #$01                    ; 
                        beq B_8e6a                  ; 
                        jmp LO_2644                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8e6a                  lda HI_9720,x               ; 
                        jmp LO_260d                 ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda SP0COL,x                ; VIC($D027) Color Sprite 0
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
C64ResetAll             jsr SpriteOffC64Reset       ; 
                        
                        lda #$00                    ; 
                        sta CIACRB                  ; CIA1($DC0F) Control Register B
                        
C64ResetAllX            rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8e83                 bcc B_8e90                  ; 
                        lda #$10                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp LO_275b                 ; 
                        
B_8e90                  lda #$ef                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp LO_275b                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda GR_bed0,x               ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #$3d                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8ea3                 lda GR_bed0,x               ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #$31                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8eab                 lda GR_bed0,x               ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #$37                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda GR_bed0,x               ; obsolete
                        cmp #$13                    ; 
                        bcc B_8ebd                  ; 
                        
                        jmp LO_28bc                 ; 
                        
B_8ebd                  lda HI_97be                 ; 
                        jmp LO_288f                 ; bad address
; -------------------------------------------------------------------------------------------------------------- ;
HI_8ec3                 sbc HI_975e                 ; 
                        bcs B_8eca                  ; 
                        lda #$70                    ; 
B_8eca                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8ecb                  ldx #$05                    ; 
B_8ecd                  lda HI_9718,x               ; 
                        cmp #$ff                    ; 
                        beq B_8eda                  ; 
                        inx                         ; 
                        cpx #$08                    ; 
                        bne B_8ecd                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8eda                  jmp LO_2a23                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8edd                 jsr LO_34f9                 ; 
                        
                        lda #$02                    ; 
                        sta HI_971d                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8ee6                 sta HI_9668,x               ; 
                        sta HI_9710,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8eed                 jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$28                    ; 
                        bcc B_8f12                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$13                    ; 
                        bcs B_8f15                  ; 
                        lda HI_97be                 ; 
                        cmp #$03                    ; 
                        bne B_8f18                  ; 
                        lda GR_bed0,x               ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #$3d                    ; 
                        sta BH_SpritePointers,x     ; 
                        jmp LO_2899                 ; 
B_8f12                  jmp LO_28c0                 ; 
B_8f15                  jmp LO_28bc                 ; 
B_8f18                  jmp LO_289e                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f1b                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f1b                  subroutine                  ; 
                        jsr LO_350f                 ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_8f2b                  ; 
                        lda #$10                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp J_8f30                  ; 
B_8f2b                  lda #$ef                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
J_8f30                  sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8f37                 lda #$04                    ; 
                        sta HI_9658,x               ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8f40                 tay                         ; 
                        lda #$02                    ; 
                        sta HI_9658,x               ; 
                        tya                         ; 
                        eor #$ff                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8f4a                 sta HI_970c                 ; 
                        lda #$01                    ; 
                        sta HI_97be                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8f53                 sta SPENA                   ; VIC($D015) Sprite Enable Register
                        jsr LO_28db                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8f5a                 nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jsr S_8f1b                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #$01                    ; 
                        sta HI_9798,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8f6c                 dex                         ; 
                        cpx #$04                    ; 
                        beq B_8f74                  ; 
                        jmp LO_28fa                 ; 
B_8f74                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8f75                 sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #$10                    ; 
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8f81                 sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        jsr LO_350f                 ; 
                        eor #$ff                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8f93                  lda HI_972b                 ; 
                        beq B_8f99                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8f99                  lda HI_9720,x               ; 
                        jmp J_72ca                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f9f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f9f                  subroutine                  ; 
                        lda #$00                    ; 
                        sta HI_9718,x               ; 
                        sta HI_961e                 ; 
                        jsr LO_3503                 ; 
                        jsr S_7327                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8fae                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8fae                  subroutine                  ; 
                        jsr S_72c5                  ; 
                        jsr S_7370                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8fb5                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8fb5                  subroutine                  ; 
                        lda #$ff                    ; 
                        sta HI_9720,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8fbb                 sta HI_9718,x               ; 
                        sta HI_9720,x               ; 
                        lda #$00                    ; 
                        sta HI_9658,x               ; 
                        sta HI_9660,x               ; 
                        sta HI_965c                 ; 
                        sta HI_9664                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8fd0                  cmp #$06                    ; 
                        bcs B_8fda                  ; 
                        jsr LO_350f                 ; 
                        jmp J_72d7                  ; 
B_8fda                  jmp J_72ce                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8fdd                 txa                         ; 
                        tay                         ; 
                        jmp J_8ecb                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8fe2                 sta HI_97ba                 ; 
                        sty HI_97b9                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8fe9                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8fe9                  subroutine                  ; 
                        sta HI_9798,x               ; 
                        sta HI_9658,x               ; 
                        sta HI_9660,x               ; 
                        sta HI_965c                 ; 
                        sta HI_9664                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_8ff9                  dc.b $11 ; .hbu.
                        dc.b $a9 ; 
                        dc.b $00 ; 
                        dc.b $8d ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_8ffd                 sta HI_969a                 ; 
                        lda #$01                    ; 
                        sta HI_96c2                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9006                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9006                  subroutine                  ; 
                        sta HI_972c                 ; 
                        lda #$6b                    ; 
                        sta BH_SpritePointer03      ; 
                        lda #$00                    ; 
                        sta T_bed3                  ; 
                        lda #$08                    ; 
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda #$01                    ; 
                        sta T_979b                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_901f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_901f                  subroutine                  ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        inc T_bed3                  ; 
                        lda T_bed3                  ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        eor #$ff                    ; 
                        sec                         ; 
                        adc #$6b                    ; 
                        cmp #$64                    ; 
                        bcc B_9036                  ; 
                        sta BH_SpritePointer03      ; 
B_9036                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_9037                 sta HI_979d                 ; 
                        lda #$09                    ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9040                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9040                  subroutine                  ; 
                        lda T_972d                  ; 
                        jsr S_7efc                  ; 
                        
                        tya                         ; 
                        jsr BL_MakeDigit            ; xr=right nibble yr=left nibble
                        sty BH_Scrn_Status + $03de  ; 
                        stx BH_Scrn_Status + $03dd  ; 
                        
                        lda #WHITE                  ; 
                        sta COLORAM + $03de         ; 
                        sta COLORAM + $03dd         ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9059                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9059                  subroutine                  ; 
                        jsr LO_33ea                 ; ResetTOD
                        lda #$01                    ; 
                        sta T_9728                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9062                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9062                  subroutine                  ; 
                        lda T_9728                  ; 
                        cmp #$01                    ; 
                        beq B_906a                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_906a                  lda TODSEC                  ; CIA1($DC09) Time of Day Clock Seconds
                        cmp #$05                    ; 
                        beq B_9082                  ; 
                        
                        lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        sta TabBackGroundColor      ; 
                        sta TabScrnStatusTextColor  ; 
                        
                        ldy #$18                    ; 
                        ldx #<TabTextStatusShipDestr; 
                        jsr BL_ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9082                  lda #$00                    ; 
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
                        sta T_9728                  ; 
                        
                        lda #CYAN                   ; 
                        sta TabBackGroundColor      ; 
                        
                        jsr S_65ff                  ; 
                        jsr BL_ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9096                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9096                  subroutine                  ; 
                        ldx #<ScreenDataOpenSea     ; 
                        ldy #>ScreenDataOpenSea     ; 
                        jsr BL_ScreenGraphicInit    ; Init game screen data - Sea battle (Ships)
                        jsr HI_80e9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_90a1                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_90a1                  subroutine                  ; 
                        sta HI_972c                 ; $00
                        sta TabJoysticAction        ; 
                        jsr HI_8d82                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_90ab                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_90ab                  subroutine                  ; 
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        ldx #$72                    ; 
                        stx BH_SpritePointer05      ; 
                        inx                         ; 
                        stx BH_SpritePointer06      ; 
                        inx                         ; 
                        stx BH_SpritePointer07      ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_90bc                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_90bc                  subroutine                  ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        lda #$73                    ; 
                        sta XT_49ce                 ; 
                        lda #$20                    ; 
                        sta XT_5cd0                 ; 
                        lda #$70                    ; 
                        sta XT_5cd3                 ; 
                        lda #$22                    ; 
                        sta XT_5cd6                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta HI_968b                 ; 
                        lda #$06                    ; 
                        sta U_79a9                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_90dd                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_90dd                  subroutine                  ; 
                        ldy #$07                    ; 
                        lda #$00                    ; 
B_90e1                  clc                         ; 
                        ldx HI_9798,y               ; 
                        beq B_90e8                  ; 
                        
                        sec                         ; 
                        
B_90e8                  rol a                       ; 
                        dey                         ; 
                        bpl B_90e1                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_90ed                 jsr S_90dd                  ; 
                        
                        tax                         ; 
                        lda #$00                    ; 
                        jsr HI_8d82                 ; 
                        
                        lda #$00                    ; 
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
                        sta TO2HRS                  ; CIA2($DD0B) Time of Day Clock Hours
                        jsr LO_37fc                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_9102                 jsr LO_37fc                 ; 
                        
                        txa                         ; 
                        jsr HI_8d82                 ; 
                        
                        lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        sta TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        
                        lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        sta TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_9116                  dc.b $b0 ; 
                        dc.b $ad ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9118                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9118                  subroutine                  ; 
                        jsr BL_ScreenStatusShowShips; 
                        
                        lda CHR_LOR                 ; Char ROM($dc00) lower case reversed
                        eor #$ff                    ; 
                        and #$03                    ; 
                        bne B_912f                  ; 
                        lda #$00                    ; 
                        sta HI_9718                 ; 
                        lda #$14                    ; 
                        sta HI_96e8                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_912f                  lda HI_9718                 ; 
                        bne B_9145                  ; 
                        lda #$04                    ; 
                        sta HI_96ae                 ; 
                        sta HI_96fe                 ; 
                        lda #$01                    ; 
                        sta HI_9718                 ; 
                        sta HI_96d6                 ; 
B_9144                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9145                  lda HI_96d6                 ; 
                        bne B_9144                  ; 
                        jsr S_9332                  ; 
                        cmp #$01                    ; 
                        beq B_9144                  ; 
                        dec HI_96e8                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9155                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9155                  subroutine                  ; 
                        lda #$0b                    ; 
                        sta U_7281                  ; 
                        jsr S_9197                  ; 
                        lda #$09                    ; 
                        sta U_7281                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9163                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9163                  subroutine                  ; 
                        sta T_961c                  ; 
                        lda #$84                    ; 
                        sta T_9709                  ; 
                        lda #$01                    ; 
                        sta T_9799                  ; 
                        lda #$00                    ; 
                        sta T_9701                  ; 
                        sta T_9711                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9179                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9179                  subroutine                  ; 
                        lda #$00                    ; 
                        sta T_9799                  ; 
                        ldx #$01                    ; 
                        jsr LO_3503                 ; 
                        lda T_9738                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9187                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9187                  subroutine                  ; 
                        lda T_961c                  ; 
                        sec                         ; 
                        sbc #$0a                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta BH_SpritePointer01      ; 
                        ldx #$01                    ; 
                        jsr LO_34f9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9197                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9197                  subroutine                  ; 
                        lda #$00                    ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        jsr S_7257                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_91a0                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_91a0                  subroutine                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        ldx #$01                    ; 
                        jsr LO_34f9                 ; 
                        
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$0c                    ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        dec SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        dec SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_91bc                  bcc B_91c4                  ; 
                        cmp SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        jmp J_7bc2                  ; 
B_91c4                  jmp J_7bc4                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_91c7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_91c7                  subroutine                  ; 
                        sta XT_49bc                 ; 
                        sta XT_49e4                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_91ce                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_91ce                  subroutine                  ; 
                        inc T_96b4                  ; 
                        inc SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda #CYAN                   ; 
                        sta TabBackGroundColor      ; 
                        
                        lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp #$03                    ; 
                        bne B_91e9                  ; 
                        lda #$fd                    ; 
                        and SPENA                   ; VIC($D015) Sprite Enable Register
B_91e9                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_91ea                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_91ea                  subroutine                  ; 
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        cmp #$98                    ; 
                        bcc B_91fb                  ; 
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        ora TabSprtBackCollReg      ; 
                        sta TabSprtBackCollReg      ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_91fb                  jsr BL_GetSprtBackCollReg   ; sprite/foregr collision
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_91ff                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_91ff                  subroutine                  ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        ldx #$02                    ; 
                        jsr LO_34f9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9208                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9208                  subroutine                  ; 
                        clc                         ; 
                        adc #$08                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_920f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_920f                  subroutine                  ; 
                        jsr LO_37e2                 ; 
                        jsr S_9239                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda T_9728                  ; 
                        cmp #$01                    ; 
                        beq B_921e                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_921e                  jsr S_9062                  ; 
                        jsr HI_80e9                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9225                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9225                  subroutine                  ; 
                        lda T_96eb                  ; 
                        sec                         ; 
                        sbc #$02                    ; 
                        sta T_96eb                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_922f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_922f                  subroutine                  ; 
                        sta HI_96b3                 ; 
                        sta T_96eb                  ; 
                        sta T_969b                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9239                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9239                  subroutine                  ; 
                        lda T_9728                  ; 
                        cmp #$01                    ; 
                        beq B_9241                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9241                  jsr S_9062                  ; 
                        lda T_9728                  ; 
                        bne B_924c                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
B_924c                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_924d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_924d                  subroutine                  ; 
                        lda HI_97bf                 ; 
                        bpl B_9253                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9253                  cmp #$05                    ; 
                        beq B_925c                  ; 
                        tax                         ; 
                        jsr S_7d64                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_925c                  jsr S_7cd9                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_9260                 lda HI_972b                 ; 
                        bne B_9266                  ; 
                        
                        rts                         ; 
                        
B_9266                  jsr S_7e99                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_926a                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_926a                  subroutine                  ; 
                        jsr S_90a1                  ; 
                        
                        lda #$00                    ; 
                        sta HI_972b                 ; 
                        lda #$ff                    ; 
                        sta HI_97bf                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9278                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9278                  subroutine                  ; 
                        sta T_968c                  ; 
                        lda #$05                    ; 
                        sta HI_97bf                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9281                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9281                  subroutine                  ; 
                        sta HI_9619                 ; 
                        lda #$ff                    ; 
                        sta HI_97bf                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_928a                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_928a                  subroutine                  ; 
                        jsr LO_3784                 ; 
                        lda #$ff                    ; 
                        sta HI_97bf                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9293                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9293                  subroutine                  ; 
                        jsr S_91a0                  ; 
                        lda #$01                    ; 
                        sta HI_972b                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_929c                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_929c                  subroutine                  ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        dec HI_972b                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr S_7e82                  ; 
                        dec T_9738                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_92aa                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_92aa                  subroutine                  ; 
                        jsr S_9308                  ; 
                        cpx T_972e                  ; 
J_92b0                  bne B_92ba                  ; 
                        jsr S_92c0                  ; 
                        lda #$94                    ; 
                        sta HI_972f                 ; 
B_92ba                  jsr S_9293                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        rol a                       ; 
A_92bf                  dc.b $7b ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_92c0                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_92c0                  subroutine                  ; 
                        ldy #$00                    ; 
                        ldx T_972e                  ; 
B_92c5                  inx                         ; 
                        cpx #$05                    ; 
                        bne B_92d7                  ; 
                        cpy #$01                    ; 
                        bne B_92d4                  ; 
                        lda #$ff                    ; 
                        sta T_972e                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_92d4                  iny                         ; 
                        ldx #$01                    ; 
B_92d7                  stx T_972e                  ; 
                        lda HI_9730,x               ; 
                        beq B_92c5                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_92e0                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_92e0                  subroutine                  ; 
                        dec T_9738                  ; 
                        lda #$df                    ; 
                        and HI_9619                 ; 
                        sta HI_9619                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_92ec                  lda #CYAN                   ; 
                        sta TabBackGroundColor      ; 
                        
                        lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp #$03                    ; 
                        bne B_9300                  ; 
                        lda #$fd                    ; 
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        jmp J_7ea3                  ; 
B_9300                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9301                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9301                  subroutine                  ; 
                        jsr LO_1fc2                 ; 
                        jsr S_7e82                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9308                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9308                  subroutine                  ; 
                        sta BH_SpritePointer01      ; 
                        jsr S_9339                  ; 
                        eor #$ff                    ; 
                        and HI_9619                 ; 
                        sta HI_9619                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9317                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9317                  subroutine                  ; 
                        ldx #$05                    ; 
                        jsr S_7e82                  ; 
                        dec T_9738                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9320                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9320                  subroutine                  ; 
                        lda HI_97bf                 ; 
                        eor #$ff                    ; 
                        ora HI_9619                 ; 
                        ora HI_972c                 ; 
                        ora T_9728                  ; 
                        ora T_9719                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9332                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9332                  subroutine                  ; 
                        inc HI_96d6                 ; 
                        lda HI_96e8                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9339                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9339                  subroutine                  ; 
                        lda #$00                    ; 
                        sta HI_9730,x               ; 
                        jsr LO_350f                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9342                  lda HI_97bf                 ; 
                        bmi B_9348                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9348                  lda T_961d                  ; 
                        jmp J_7f71                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HI_934e               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HI_934e                 sta TabPlayerLivesSav,x     ; 
                        
                        lda #$40                    ; 
                        sta T_960a                  ; 
                        
                        lda #$01                    ; 
                        sta T_960c                  ; 
                        
                        lda #$32                    ; 
                        sta HI_960b                 ; 
                        
                        lda #$00                    ; 
                        jsr S_952b                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9366                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9366                  subroutine                  ; 
                        pha                         ; 
                        jsr LO_34f9                 ; 
                        
                        pla                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_936c                 ldx #$07                    ; 
B_936e                  jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda TabSpriteScrollAddX,x   ; 
                        bmi B_9393                  ; 
                        
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc TabSpriteScrollAddX,x   ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$00                    ; 
                        sta TabSpriteScrollAddX,x   ; 
                        bcc B_93a4                  ; 
                        
B_9387                  jsr LO_350f                 ; 
                        
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp B_93a4                  ; 
                        
B_9393                  lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc TabSpriteScrollAddX,x   ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$00                    ; 
                        sta TabSpriteScrollAddX,x   ; 
                        bcc B_9387                  ; 
                        
B_93a4                  dex                         ; 
                        bne B_936e                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_93a8                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_93a8                  subroutine                  ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        txa                         ; 
                        clc                         ; 
                        adc #$43                    ; 
                        sta BH_SpritePointers,x     ; 
                        sta XT_4ff8,x               ; 
                        jsr LO_350f                 ; 
                        
                        ora SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankInitSpriteLevel   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankInitSpriteLevel     subroutine                  ; 
                        sta T_975f                  ; 
                        
                        lda #$03                    ; 
                        sta T_973e                  ; 
                        
                        lda TabBeachSpriteLevel     ; 
                        sta TabBeachSpriteLevelTmp  ; 
                        
TankInitSpriteLevelX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_93ce                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_93ce                  subroutine                  ; 
                        ldx #$06                    ; 
B_93d0                  jsr LO_350f                 ; 
                        
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_93f5                  ; 
                        
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$58                    ; 
                        bcc B_9409                  ; 
                        
                        lda #$00                    ; 
                        sta HI_9718,x               ; 
                        jsr LO_350f                 ; 
                        
                        eor #$ff                    ; 
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        jmp B_9409                  ; 
                        
B_93f5                  jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$e0                    ; 
                        bcc B_9409                  ; 
                        
                        cpx T_973d                  ; 
                        bne B_9409                  ; 
                        
                        lda #$00                    ; 
                        sta T_973d                  ; 
                        
B_9409                  dex                         ; 
                        cpx #$02                    ; 
                        bne B_93d0                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_940f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_940f                  subroutine                  ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        sta HI_9718,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9416                  jsr LO_350f                 ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_9424                  ; 
                        jsr BL_SetYrToXrMult2       ; yr = xr * 2
                        jmp J_83ef                  ; 
B_9424                  jmp B_83fa                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9427                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9427                  subroutine                  ; 
                        and TabSprtSprtCollReg      ; 
                        cmp #$05                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_942d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_942d                  subroutine                  ; 
                        jsr LO_1e8d                 ; 
                        
                        lda #$00                    ; 
                        sta TabJoysticAction        ; 
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9439                  jsr BL_ClearDirInJoyAction  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$20                    ; 
                        bne B_9446                  ; 
                        
                        jmp J_8488                  ; 
                        
B_9446                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr TankPlayerChkCollBack   ; 
                        jsr TankPlayerChkCollSprt   ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr S_7983                  ; 
                        jsr S_8da6                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9455                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9455                  subroutine                  ; 
                        sta T_961a                  ; 
                        
                        lda #$00                    ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        
                        lda #$01                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9463                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9463                  subroutine                  ; 
                        jsr S_7983                  ; 
                        jsr S_8da6                  ; 
                        
                        lda #$b5                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_946f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_946f                  subroutine                  ; 
                        lsr a                       ; 
                        sta HI_9740                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr LO_3503                 ; 
                        dec T_9719                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_947b                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_947b                  subroutine                  ; 
                        jsr ScreenStatusTanksLeft   ; 
                        jsr S_949d                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9482                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9482                  subroutine                  ; 
                        lda #$01                    ; 
                        sta HI_972b                 ; 
                        sta T_96b7                  ; 
                        ldx #$07                    ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$10                    ; 
                        sta T_968f                  ; 
                        dec T_9719                  ; 
                        ldx #$01                    ; 
                        jsr LO_3503                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_949d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_949d                  subroutine                  ; 
                        lda HI_972b                 ; 
                        bne B_94a3                  ; 
B_94a2                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_94a3                  lda T_96b7                  ; 
                        bne B_94a2                  ; 
                        dec HI_972b                 ; 
                        ldx #$07                    ; 
                        jsr LO_3503                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_94b1                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_94b1                  subroutine                  ; 
                        sta HI_9620                 ; 
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$fd                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_94bd                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_94bd                  subroutine                  ; 
                        sta T_96db                  ; 
                        
HI_94c1                 equ * + $01                 ; 
                        lda #$ff                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_94c3                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_94c3                  subroutine                  ; 
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_94cd                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_94cd                  subroutine                  ; 
                        sta XT_48b6                 ; 
                        
                        lda #[COLORAM_MCM_On | CYAN]; 
                        sta COLORAM + $00b3         ; 
                        sta COLORAM + $00b4         ; 
                        sta COLORAM + $00b5         ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda T_96d1                  ; 
                        bne B_94e8                  ; 
                        
                        pha                         ; 
                        
                        lda TabBeachSpriteLevelTmp  ; 
                        jmp J_8372                  ; 
                        
B_94e8                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta TabBeachSpriteLevelTmp  ; 
                        
                        inc T_96d1                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankGoInitSpriteLevel Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankGoInitSpriteLevel   subroutine                  ; 
                        jsr TankInitSpriteLevel     ; 
                        
                        lda #$1e                    ; 
                        sta T_96f9                  ; 
                        
TankGoInitSpriteLevelX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
S_94f9                  subroutine                  ; not dispatched
                        lda TabBeachSpriteLevel     ; 
                        beq B_9501                  ; 
                        
                        dec TabBeachSpriteLevel     ; 
                        
B_9501                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9502                  pha                         ; 
                        
                        lda T_96d1                  ; 
                        bne B_9511                  ; 
                        
                        inc T_96d1                  ; 
                        
                        lda TabBeachSpriteLevelTmp  ; 
                        jmp J_8372                  ; 
                        
B_9511                  pla                         ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9513                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9513                  subroutine                  ; 
                        jsr BL_WaitTOD              ; 
                        
                        lda TabBeachSpriteLevel     ; 
                        beq B_951e                  ; 
                        
                        dec TabBeachSpriteLevel     ; 
                        
B_951e                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerChkCollision  jsr TankPlayerChkCollBack   ; 
                        jsr TankPlayerChkCollSprt   ; 
                        
TankPlayerChkCollisionX jmp ChapTanksOnBeachBack    ; back to chapter
; -------------------------------------------------------------------------------------------------------------- ;
A_9528                  dc.b $b0 ; 
                        dc.b $8d ; 
                        dc.b $93 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_952b                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_952b                  subroutine                  ; 
                        sta TabJoysticAction        ; $00
                        sta SPSPCL                  ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                        sta SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        jsr S_95bb                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda #$00                    ; 
                        ldy MapChar3f + $03         ; 
                        sta MapChar3f + $06,y       ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        ldy.w BHZ_00a9              ; <obsolete>-> ldy BHZ_a9
                        sta TabJoysticAction        ; 
                        sta SPBGPR                  ; VIC($D01B) Sprite to Foreground Display Priority
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_954b                 sta BH_Scrn_Status + $03c0,x; 
                        lda #$01                    ; 
                        cpy HI_9612                 ; 
                        bcc B_955a                  ; 
                        beq B_955a                  ; 
                        jmp LO_3ab0                 ; 
B_955a                  jmp LO_3ab2                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_955d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_955d                  subroutine                  ; 
                        inx                         ; 
                        lda #$20                    ; 
                        sta BH_Scrn_Status + $03c0,x; 
                        inx                         ; 
                        dey                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        jsr LO_2ba8                 ; .hbu. - bad
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr S_73fd                  ; 
                        jsr LO_2bc0                 ; .hbu. - bad
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta HI_9756,x               ; 
                        jsr LO_2bca                 ; .hbu. - bad
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sec                         ; 
                        sbc #$02                    ; 
                        sta PWHI3                   ; SID($D411) Oscillator 3 Pulse Waveform Width (high nybble)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SpritesReset          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SpritesReset            subroutine                  ; 
HI_9582                 equ *                       ; 
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPBGPR                  ; VIC($D01B) Sprite to Foreground Display Priority
                        sta TabJoysticAction        ; 
                        
                        lda SPSPCL                  ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        
SpritesResetX           rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9594                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9594                  subroutine                  ; 
                        sta HI_972c                 ; 
                        sta T_9728                  ; 
                        jsr SpritesReset            ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_959e                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_959e                  subroutine                  ; 
                        sta HI_968b                 ; 
                        jsr SpritesReset            ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_95a5                  jsr SpritesReset            ; 
                        
                        jmp LO_2c8f                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankGoResetSprites    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankGoResetSprites      subroutine                  ; 
U_95ac                  equ * + $01                 ; 
                        sta HI_972a                 ; 
                        jsr SpritesReset            ; 
                        
TankGoResetSpritesX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HI_95b2                 lda #$00                    ; 
                        jsr HI_8d82                 ; 
                        jsr S_6676                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_95bb                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_95bb                  subroutine                  ; 
                        jsr HI_8d82                 ; 
                        
                        lda TabGameMode             ; 
                        bne B_95c8                  ; 
                        
                        lda #$00                    ; 
                        sta TO2HRS                  ; CIA2($DD0B) Time of Day Clock Hours
                        
B_95c8                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        cmp #$09                    ; 
                        bcc B_95cf                  ; 
                        lda #$08                    ; 
B_95cf                  sta HI_960f                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_95d3                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_95d3                  subroutine                  ; 
                        clc                         ; 
                        adc T_97c8                  ; 
                        jsr S_7efc                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_95db                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_95db                  subroutine                  ; 
                        jsr S_7fee                  ; 
                        jsr S_95e2                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_95e2                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_95e2                  subroutine                  ; 
                        jsr LO_2b74                 ; 
J_95e5                  cmp #$0d                    ; 
                        bcc B_95ee                  ; 
                        sbc #$0d                    ; 
                        
HI_95ec                 equ * + $01                 ;                         
                        jmp J_95e5                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_95ee                  sta T_97c8                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_95f2                  dc.b $0b ; .hbu.
                        dc.b $dc ; 
                        dc.b $bd ; 
                        dc.b $f0 ; 
                        dc.b $9e ; 
                        dc.b $8d ; 
                        dc.b $0a ; 
                        dc.b $dc ; 
                        dc.b $bd ; 
                        dc.b $ee ; 
                        dc.b $9e ; 
                        dc.b $8d ; 
                        dc.b $09 ; 
                        dc.b $dc ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSkillLevel           dc.b $01 ; 
TabNumberOfPlayers      dc.b $01 ; 
HI_9602                 dc.b $01 ; 
                        dc.b $00 ; 
TabActualPlayerNumber   dc.b $00 ; 
TabScrnStatusTextColor  dc.b $00 ; 
HI_9606                 dc.b $20 ; 
HI_9607                 dc.b $01 ; 
HI_9608                 dc.b $02 ; 
HI_9609                 dc.b $81 ; 
T_960a                  dc.b $85 ; 
HI_960b                 dc.b $ad ; 
T_960c                  dc.b $00 ; 
HI_960d                 dc.b $0a ; 
TabPlayerLives          dc.b $02 ; 
HI_960f                 dc.b $00 ; 

HI_9610                 equ  *   ; 
HillTargetsToHit        dc.b $0a ; 
T_9611                  dc.b $01 ; 
HI_9612                 dc.b $02 ; 
HI_9613                 dc.b $07 ; 
T_9614                  dc.b $00 ; 
TabSprtSprtCollReg      dc.b $00 ; 
TabSprtBackCollReg      dc.b $00 ; 
HI_9617                 dc.b $05 ; 
HI_9618                 dc.b $09 ; 
HI_9619                 dc.b $3e ; 
T_961a                  dc.b $4d ; 
HI_961b                 dc.b $60 ; 
T_961c                  dc.b $9c ; 
T_961d                  dc.b $60 ; 
HI_961e                 dc.b $00 ; 
T_961f                  dc.b $01 ; 
HI_9620                 dc.b $00 ; 
                        
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
T_9623                  dc.b $00 ; 
T_9624                  dc.b $00 ; 
T_9625                  dc.b $00 ; 
T_9626                  dc.b $00 ; 
T_9627                  dc.b $00 ; 
HI_9628                 dc.b $41 ; 
                        dc.b $00 ; 
TabTankActiveScreen     dc.b $01 ; screen A
TabVicMemControl        dc.b $20 ; 
TabVicMemControlSetA    dc.b $20 ; ..#. ... o - Scrn_adr=$0800-$0be7($02) Chars=$0000-$07ff
TabVicMemControlSetB    dc.b $30 ; ..## ... o - Scrn_adr=$0c00-$0fe7($03) Chars=$0000-$07ff
TabBackGroundColor      dc.b YELLOW
HI_962f                 dc.b $00 ; 
TabVicScrollSoftPosY    dc.b $03 ; 
TabTankScrollSoftPosY   dc.b $00 ; 
TabVicScrollSoftPosX    dc.b $00 ; 
TabTankScrollSoftPosX   dc.b $03 ; 
TabScreenTankColorFlag  dc.b $00 ; 
BH_TabScrnTankPosY      dc.b $14 ; 
TabTankObstMax          dc.b $00 ; 
TabTankObstData         dc.b $00 ; 
TabTankObstColor        dc.b $06 ; 

HI_9639                 equ  *   ; 
TabTankObstOffNext      dc.b $00 ; 
TabScrnTankPosX         dc.b $00 ; 
TabScrnTankBayCharPtr   dc.b $04 ; 
                        dc.b $03 ; 
TabScrnTankBayScrollPos dc.b $ae ; 
HI_963e                 dc.b $d5 ; 
TabTankScrollAreaTabPtr dc.b $00 ; 
T_9640                  dc.b $00 ; 
                        dc.b $00 ; 
HI_9642                 dc.b $38 ; 
HI_9643                 dc.b $04 ; 
TabTankSprtScrollSpeed  dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
TabJoysticAction        dc.b $00 ; 
HI_9656                 dc.b $01 ; 
TabGameMode             dc.b $00 ; 
HI_9658                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_965c                 dc.b $00 ; 
HI_965d                 dc.b $00 ; 
                        dc.b $00 ; 
T_965f                  dc.b $00 ; 
HI_9660                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_9664                 dc.b $00 ; 
T_9665                  dc.b $00 ; 
T_9666                  dc.b $00 ; 
T_9667                  dc.b $00 ; 
HI_9668                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_966c                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
TabMoveSpriteLeRi       equ  *   ; 
TabMoveSpriteNo           = $00  ; 
TabMoveSpriteRi           = $01  ; 
TabMoveSpriteLe           = $ff  ; 
HI_9670                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_9674                 dc.b $00 ; 
T_9675                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
TabMoveSpriteUpDo       equ  *   ; 
TabMoveSpriteUp           = $01  ; 
TabMoveSpriteDo           = $ff  ; 
HI_9678                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_967c                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
HI_9680                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
T_9684                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_9688                 dc.b $01 ; 
T_9689                  dc.b $01 ; 
HI_968a                 dc.b $01 ; 
HI_968b                 dc.b $01 ; 
T_968c                  dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
T_968f                  dc.b $01 ; 
                        dc.b $02 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $06 ; 
                        dc.b $06 ; 
HI_9698                 dc.b $01 ; 
T_9699                  dc.b $01 ; 
HI_969a                 dc.b $01 ; 
T_969b                  dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
T_96a0                  dc.b $02 ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $1e ; 
                        dc.b $1e ; 
                        dc.b $1e ; 
HI_96a8                 dc.b $01 ; 
T_96a9                  dc.b $01 ; 
                        dc.b $01 ; 
T_96ab                  dc.b $01 ; 
HI_96ac                 dc.b $01 ; 
HI_96ad                 dc.b $01 ; 
HI_96ae                 dc.b $01 ; 
                        dc.b $20 ; 
HI_96b0                 dc.b $00 ; 
T_96b1                  dc.b $00 ; 
T_96b2                  dc.b $00 ; 
HI_96b3                 dc.b $00 ; 
T_96b4                  dc.b $00 ; 
T_96b5                  dc.b $00 ; 
                        dc.b $00 ; 
T_96b7                  dc.b $00 ; 
HI_96b8                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_96c0                 dc.b $00 ; 
T_96c1                  dc.b $00 ; 
HI_96c2                 dc.b $00 ; 
T_96c3                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_96c8                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_96d0                 dc.b $00 ; 
T_96d1                  dc.b $00 ; 
                        dc.b $00 ; 
T_96d3                  dc.b $00 ; 
HI_96d4                 dc.b $00 ; 
HI_96d5                 dc.b $00 ; 
HI_96d6                 dc.b $00 ; 
HI_96d7                 dc.b $00 ; 
HI_96d8                 dc.b $01 ; 
T_96d9                  dc.b $01 ; 
T_96da                  dc.b $01 ; 
T_96db                  dc.b $01 ; 
T_96dc                  dc.b $01 ; 
T_96dd                  dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
HI_96e0                 dc.b $02 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $06 ; 
                        dc.b $06 ; 
HI_96e8                 dc.b $01 ; 
T_96e9                  dc.b $01 ; 
T_96ea                  dc.b $01 ; 
T_96eb                  dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
HI_96f0                 dc.b $02 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $1e ; 
                        dc.b $1e ; 
                        dc.b $1e ; 
HI_96f8                 dc.b $01 ; 
T_96f9                  dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
HI_96fd                 dc.b $01 ; 
HI_96fe                 dc.b $01 ; 
HI_96ff                 dc.b $20 ; 
HI_9700                 dc.b $00 ; 
T_9701                  dc.b $00 ; 
T_9702                  dc.b $00 ; 
T_9703                  dc.b $00 ; 
HI_9704                 dc.b $00 ; 
HI_9705                 dc.b $00 ; 
T_9706                  dc.b $00 ; 
T_9707                  dc.b $00 ; 
HI_9708                 dc.b $00 ; 
T_9709                  dc.b $00 ; 
T_970a                  dc.b $00 ; 
T_970b                  dc.b $00 ; 
HI_970c                 dc.b $00 ; 
T_970d                  dc.b $00 ; 
T_970e                  dc.b $00 ; 
T_970f                  dc.b $00 ; 
HI_9710                 dc.b $00 ; 
T_9711                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_9714                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_9718                 dc.b $00 ; 
T_9719                  dc.b $00 ; 
T_971a                  dc.b $00 ; 
T_971b                  dc.b $00 ; 
T_971c                  dc.b $00 ; 
HI_971d                 dc.b $00 ; 
T_971e                  dc.b $00 ; 
T_971f                  dc.b $00 ; 
HI_9720                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
T_9724                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
T_9728                  dc.b $00 ; 
HI_9729                 dc.b $00 ; 
HI_972a                 dc.b $0a ; 
HI_972b                 dc.b $00 ; 
HI_972c                 dc.b $01 ; 
T_972d                  dc.b $14 ; 
T_972e                  dc.b $03 ; 
HI_972f                 dc.b $a0 ; 
HI_9730                 dc.b $01 ; 
T_9731                  dc.b $01 ; 
T_9732                  dc.b $01 ; 
T_9733                  dc.b $01 ; 
T_9734                  dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
T_9738                  dc.b $01 ; 
T_9739                  dc.b $00 ; 
TabBeachSpriteLevel     dc.b $05 ; 
TabBeachSpriteLevelTmp  dc.b $02 ; 
HI_973c                 dc.b $00 ; 
T_973d                  dc.b $00 ; 
T_973e                  dc.b $03 ; 
T_973f                  dc.b $00 ; 
HI_9740                 dc.b $07 ; 
T_9741                  dc.b $63 ; 
HI_9742                 dc.b $a8 ; 
TabPlayersSaveArea      equ  *   ; 
TabPlayerLivesSav       dc.b $02 ; p1
A_9744                  dc.b $00 ; p2
                        
HI_9745                 dc.b $81 ; p1
A_9746                  dc.b $01 ; 
                        
HI_9747                 dc.b $00 ; p1
A_9748                  dc.b $00 ; 
                        
HI_9749                 dc.b $00 ; 
A_974a                  dc.b $00 ; 
                        
HI_974b                 dc.b $20 ; p1
A_974c                  dc.b $30 ; p2
                        
HI_974d                 dc.b $00 ; p1
A_974e                  dc.b $00 ; p2
                        
T_974f                  dc.b $02 ; 
                        
HI_9750                 dc.b $0a ; 
A_9751                  dc.b $0a ; 
                        
TabBeachSpriteLevelSav  dc.b $05 ; player 1
                        dc.b $05 ; player 2
                        
HI_9754                 dc.b $3e ; 
A_9755                  dc.b $3e ; 
                        
HI_9756                 dc.b $a8 ; 
                        dc.b $a8 ; 

HI_9758                 dc.b $02 ; 
                        dc.b $01 ; 
                        
HI_975a                 dc.b $01 ; 
                        dc.b $00 ; 
                        
                        dc.b $dd ; 
                        dc.b $60 ; 
HI_975e                 dc.b $55 ; 
T_975f                  dc.b $04 ; 

TabSpriteScrollAddX     dc.b $dd ; 
TabSpriteScrollAddX01   dc.b $00 ; 
TabSpriteScrollAddX02   dc.b $00 ; 
TabSpriteScrollAddX03   dc.b $00 ; 
TabSpriteScrollAddX04   dc.b $00 ; 
TabSpriteScrollAddX05   dc.b $00 ; 
TabSpriteScrollAddX06   dc.b $00 ; 
TabSpriteScrollAddX07   dc.b $00 ; 
                        
TabPosEnemyCannon       dc.b $a2 ; possible posX depending on TabBeachSpriteLevel
                        dc.b $a2 ; 
                        dc.b $76 ; 
                        dc.b $a2 ; 
                        dc.b $4a ; 
                        dc.b $9a ; 
                        dc.b $14 ; 
                        dc.b $a2 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
TabPosEnemyTank         dc.b $c8 ; possible posX depending on TabBeachSpriteLevel
                        dc.b $9a ; 
                        dc.b $9a ; 
                        dc.b $a2 ; 
                        dc.b $6c ; 
                        dc.b $a2 ; 
                        dc.b $3c ; 
                        dc.b $a2 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
TabPosEnemyGunner       dc.b $b4 ; possible posX depending on TabBeachSpriteLevel
                        dc.b $92 ; 
                        dc.b $80 ; 
                        dc.b $95 ; 
                        dc.b $55 ; 
                        dc.b $97 ; 
                        dc.b $21 ; 
                        dc.b $a2 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
TabPosEnemyTurret       dc.b $bf ; possible posX depending on TabBeachSpriteLevel
                        dc.b $b2 ; 
                        dc.b $8e ; 
                        dc.b $ae ; 
                        dc.b $60 ; 
                        dc.b $82 ; 
                        dc.b $36 ; 
                        dc.b $84 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
HI_9798                 dc.b $00 ; 
T_9799                  dc.b $00 ; 
                        dc.b $00 ; 
T_979b                  dc.b $00 ; 
T_979c                  dc.b $00 ; 
HI_979d                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
HI_97a0                 dc.b $0a ; 
                        dc.b $1f ; 
                        dc.b $3b ; 
                        dc.b $03 ; 
                        dc.b $06 ; 
                        dc.b $0d ; 
                        dc.b $2d ; 
                        dc.b $07 ; 
HI_97a8                 dc.b $2c ; 
                        dc.b $39 ; 
                        dc.b $0f ; 
                        dc.b $0b ; 
                        dc.b $36 ; 
                        dc.b $14 ; 
                        dc.b $05 ; 
                        dc.b $2b ; 
HI_97b0                 dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $16 ; 
                        dc.b $32 ; 
                        dc.b $16 ; 
                        dc.b $21 ; 
HI_97b8                 dc.b $00 ; 
HI_97b9                 dc.b $05 ; 
HI_97ba                 dc.b $03 ; 
HI_97bb                 dc.b $00 ; 
HI_97bc                 dc.b $00 ; 
HI_97bd                 dc.b $aa ; 
HI_97be                 dc.b $02 ; 
HI_97bf                 dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
T_97c8                  dc.b $01 ; 
HI_97c9                 dc.b $20 ; 
HI_97ca                 dc.b $a0 ; 
HI_97cb                 dc.b $bd ; 
HI_97cc                 dc.b $0c ; 
HI_97cd                 dc.b $08 ; 
HI_97ce                 dc.b $5a ; 
                        dc.b $00 ; 
A_97d0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $80 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_97e0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_97f0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
GraphicsData            include asm\Graphic.asm  ; Screens and character sets
; -------------------------------------------------------------------------------------------------------------- ;
